/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.models;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.models.LogrotateAdditionalFile;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import java.util.ArrayList;
import java.util.List;

public class LogrotateTemplateContext {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final SingularityExecutorConfiguration configuration;

    public LogrotateTemplateContext(SingularityExecutorConfiguration configuration, SingularityExecutorTaskDefinition taskDefinition) {
        this.configuration = configuration;
        this.taskDefinition = taskDefinition;
    }

    public String getRotateDateformat() {
        return this.configuration.getLogrotateDateformat().startsWith("-") ? this.configuration.getLogrotateDateformat().substring(1) : this.configuration.getLogrotateDateformat();
    }

    public int getRotateCount() {
        return this.configuration.getLogrotateCount();
    }

    public int getMaxageDays() {
        return this.configuration.getLogrotateMaxageDays();
    }

    public String getRotateDirectory() {
        return this.configuration.getLogrotateToDirectory();
    }

    public boolean getShouldLogRotateLogFile() {
        return this.taskDefinition.shouldLogrotateLogFile();
    }

    public String getTaskDirectory() {
        return this.taskDefinition.getTaskDirectoryPath().toString();
    }

    public String getLogrotateFrequency() {
        return ((SingularityExecutorLogrotateFrequency)this.taskDefinition.getExecutorData().getLogrotateFrequency().or((Object)this.configuration.getLogrotateFrequency())).getLogrotateValue();
    }

    public String getCompressCmd() {
        return (String)this.configuration.getLogrotateCompressionSettings().getCompressCmd().orNull();
    }

    public String getUncompressCmd() {
        return (String)this.configuration.getLogrotateCompressionSettings().getUncompressCmd().orNull();
    }

    public String getCompressOptions() {
        return (String)this.configuration.getLogrotateCompressionSettings().getCompressOptions().orNull();
    }

    public String getCompressExt() {
        return (String)this.configuration.getLogrotateCompressionSettings().getCompressExt().orNull();
    }

    public List<LogrotateAdditionalFile> getExtrasFiles() {
        List<SingularityExecutorLogrotateAdditionalFile> original = this.configuration.getLogrotateAdditionalFiles();
        ArrayList<LogrotateAdditionalFile> transformed = new ArrayList<LogrotateAdditionalFile>(original.size());
        for (SingularityExecutorLogrotateAdditionalFile additionalFile : original) {
            String dateformat = additionalFile.getDateformat().isPresent() ? (((String)additionalFile.getDateformat().get()).startsWith("-") ? ((String)additionalFile.getDateformat().get()).substring(1) : (String)additionalFile.getDateformat().get()) : (this.configuration.getLogrotateExtrasDateformat().startsWith("-") ? this.configuration.getLogrotateExtrasDateformat().substring(1) : this.configuration.getLogrotateExtrasDateformat());
            transformed.add(new LogrotateAdditionalFile(this.taskDefinition.getTaskDirectoryPath().resolve(additionalFile.getFilename()).toString(), (String)additionalFile.getExtension().or((Object)Strings.emptyToNull((String)Files.getFileExtension((String)additionalFile.getFilename()))), dateformat));
        }
        return transformed;
    }

    private Optional<String> parseFilenameExtension(String filename) {
        int lastPeriodIndex = filename.lastIndexOf(46);
        if (lastPeriodIndex > -1 && !filename.substring(lastPeriodIndex + 1).contains("*")) {
            return Optional.of((Object)filename.substring(lastPeriodIndex + 1));
        }
        return Optional.absent();
    }

    public String getExtrasDateformat() {
        return this.configuration.getLogrotateExtrasDateformat();
    }

    public String getLogfile() {
        return this.taskDefinition.getServiceLogOut();
    }

    public String getLogfileExtension() {
        return this.taskDefinition.getServiceLogOutExtension();
    }

    public String getLogfileName() {
        return this.taskDefinition.getServiceLogFileName();
    }

    public boolean isUseFileAttributes() {
        return this.configuration.isUseFileAttributes();
    }

    public String toString() {
        return "LogrotateTemplateContext{taskDefinition=" + this.taskDefinition + ", configuration=" + (Object)((Object)this.configuration) + '}';
    }
}

