/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.MesosUtils;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.config.LogrotateCompressionSettings;
import com.hubspot.singularity.executor.config.SingularityExecutorDockerAuthConfig;
import com.hubspot.singularity.executor.config.SingularityExecutorLogrotateAdditionalFile;
import com.hubspot.singularity.executor.models.ThreadCheckerType;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandDescriptor;
import com.hubspot.singularity.runner.base.configuration.BaseRunnerConfiguration;
import com.hubspot.singularity.runner.base.configuration.Configuration;
import com.hubspot.singularity.runner.base.constraints.DirectoryExists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Configuration(filename="/etc/singularity.executor.yaml", consolidatedField="executor")
public class SingularityExecutorConfiguration
extends BaseRunnerConfiguration {
    @NotEmpty
    @JsonProperty
    private String executorJavaLog = "executor.java.log";
    @NotEmpty
    @JsonProperty
    private String executorBashLog = "executor.bash.log";
    @NotEmpty
    @JsonProperty
    private String defaultRunAsUser;
    @NotEmpty
    @JsonProperty
    private String taskAppDirectory = "app";
    @Min(value=0L)
    @JsonProperty
    private long shutdownTimeoutWaitMillis = TimeUnit.MINUTES.toMillis(5L);
    @Min(value=0L)
    @JsonProperty
    private long initialIdleExecutorShutdownWaitMillis = TimeUnit.MINUTES.toMillis(1L);
    @Min(value=0L)
    @JsonProperty
    private long idleExecutorShutdownWaitMillis = TimeUnit.SECONDS.toMillis(10L);
    @Min(value=0L)
    @JsonProperty
    private long stopDriverAfterMillis = TimeUnit.SECONDS.toMillis(1L);
    @NotEmpty
    @DirectoryExists
    @JsonProperty
    private String globalTaskDefinitionDirectory;
    @NotEmpty
    @JsonProperty
    private String globalTaskDefinitionSuffix = ".task.json";
    @Min(value=1L)
    @JsonProperty
    private long hardKillAfterMillis = TimeUnit.MINUTES.toMillis(3L);
    @Min(value=1L)
    @JsonProperty
    private int killThreads = 1;
    @Min(value=1L)
    @JsonProperty
    private int threadCheckThreads = 1;
    @Min(value=1L)
    @JsonProperty
    private long checkThreadsEveryMillis = TimeUnit.SECONDS.toMillis(5L);
    @Min(value=0L)
    @JsonProperty
    private int maxTaskMessageLength = 80;
    @NotEmpty
    @JsonProperty
    private String logrotateCommand = "logrotate";
    @NotEmpty
    @JsonProperty
    private String logrotateStateFile = "logrotate.status";
    @NotEmpty
    @DirectoryExists
    @JsonProperty
    private String logrotateConfDirectory = "/etc/logrotate.d";
    @NotEmpty
    @JsonProperty
    private String logrotateToDirectory = "logs";
    @Min(value=1L)
    @JsonProperty
    private int logrotateMaxageDays = 7;
    @Min(value=1L)
    @JsonProperty
    private int logrotateCount = 20;
    @NotEmpty
    @JsonProperty
    private String logrotateDateformat = "%Y%m%d%s";
    @NotEmpty
    @JsonProperty
    private String logrotateExtrasDateformat = "%Y%m%d";
    @NotNull
    @JsonProperty
    private LogrotateCompressionSettings logrotateCompressionSettings = LogrotateCompressionSettings.empty();
    @NotNull
    @JsonProperty
    private List<SingularityExecutorLogrotateAdditionalFile> logrotateAdditionalFiles = Collections.emptyList();
    @Min(value=1L)
    @JsonProperty
    private int tailLogLinesToSave = 2500;
    @JsonProperty
    private boolean useLocalDownloadService = false;
    @Min(value=1L)
    @JsonProperty
    private long localDownloadServiceTimeoutMillis = TimeUnit.MINUTES.toMillis(3L);
    @Min(value=1L)
    @JsonProperty
    private int localDownloadServiceMaxConnections = 25;
    @NotNull
    @JsonProperty
    private Optional<Integer> maxTaskThreads = Optional.absent();
    @JsonProperty
    private String dockerPrefix = "se-";
    @Min(value=5L)
    @JsonProperty
    private int dockerStopTimeout = 15;
    @NotEmpty
    @JsonProperty
    private String cgroupsMesosCpuTasksFormat = "/cgroup/cpu/%s/tasks";
    @NotEmpty
    @JsonProperty
    private String procCgroupFormat = "/proc/%s/cgroup";
    @NotEmpty
    @JsonProperty
    private String switchUserCommandFormat = "sudo -E -u %s";
    @JsonProperty
    @NotEmpty
    private List<String> artifactSignatureVerificationCommand = Arrays.asList("/usr/bin/gpg", "--verify", "{artifactSignaturePath}");
    @JsonProperty
    private boolean failTaskOnInvalidArtifactSignature = true;
    @JsonProperty
    @NotEmpty
    private String signatureVerifyOut = "executor.gpg.out";
    @JsonProperty
    public List<SingularityExecutorShellCommandDescriptor> shellCommands = Collections.emptyList();
    @NotEmpty
    @JsonProperty
    public String shellCommandOutFile = "executor.commands.{NAME}.{TIMESTAMP}.log";
    @NotEmpty
    @JsonProperty
    private String shellCommandPidPlaceholder = "{PID}";
    @NotEmpty
    @JsonProperty
    private String shellCommandUserPlaceholder = "{USER}";
    @NotEmpty
    @JsonProperty
    private String shellCommandPidFile = ".task-pid";
    @JsonProperty
    private List<String> shellCommandPrefix = Collections.emptyList();
    @JsonProperty
    private int dockerClientTimeLimitSeconds = 300;
    @JsonProperty
    private int dockerClientConnectionPoolSize = 5;
    @JsonProperty
    private int maxDockerPullAttempts = 2;
    @JsonProperty
    private Optional<SingularityExecutorDockerAuthConfig> dockerAuthConfig = Optional.absent();
    @JsonProperty
    private ThreadCheckerType threadCheckerType = ThreadCheckerType.PS;
    @JsonProperty
    private SingularityExecutorLogrotateFrequency logrotateFrequency = SingularityExecutorLogrotateFrequency.DAILY;
    @NotEmpty
    @JsonProperty
    private String cronDirectory = "/etc/cron.d";
    @JsonProperty
    private boolean useFileAttributes = false;

    public SingularityExecutorConfiguration() {
        super(Optional.of((Object)"singularity-executor.log"));
    }

    public String getShellCommandPidPlaceholder() {
        return this.shellCommandPidPlaceholder;
    }

    public void setShellCommandPidPlaceholder(String shellCommandPidPlaceholder) {
        this.shellCommandPidPlaceholder = shellCommandPidPlaceholder;
    }

    public String getShellCommandUserPlaceholder() {
        return this.shellCommandUserPlaceholder;
    }

    public void setShellCommandUserPlaceholder(String shellCommandUserPlaceholder) {
        this.shellCommandUserPlaceholder = shellCommandUserPlaceholder;
    }

    public List<SingularityExecutorLogrotateAdditionalFile> getLogrotateAdditionalFiles() {
        return this.logrotateAdditionalFiles;
    }

    public void setLogrotateAdditionalFiles(List<SingularityExecutorLogrotateAdditionalFile> logrotateAdditionalFiles) {
        this.logrotateAdditionalFiles = logrotateAdditionalFiles;
    }

    public String getExecutorJavaLog() {
        return this.executorJavaLog;
    }

    public String getExecutorBashLog() {
        return this.executorBashLog;
    }

    public String getDefaultRunAsUser() {
        return this.defaultRunAsUser;
    }

    public String getTaskAppDirectory() {
        return this.taskAppDirectory;
    }

    public long getShutdownTimeoutWaitMillis() {
        return this.shutdownTimeoutWaitMillis;
    }

    public long getIdleExecutorShutdownWaitMillis() {
        return this.idleExecutorShutdownWaitMillis;
    }

    public int getLocalDownloadServiceMaxConnections() {
        return this.localDownloadServiceMaxConnections;
    }

    public void setLocalDownloadServiceMaxConnections(int localDownloadServiceMaxConnections) {
        this.localDownloadServiceMaxConnections = localDownloadServiceMaxConnections;
    }

    public long getStopDriverAfterMillis() {
        return this.stopDriverAfterMillis;
    }

    public String getGlobalTaskDefinitionDirectory() {
        return this.globalTaskDefinitionDirectory;
    }

    public String getGlobalTaskDefinitionSuffix() {
        return this.globalTaskDefinitionSuffix;
    }

    public long getHardKillAfterMillis() {
        return this.hardKillAfterMillis;
    }

    public int getKillThreads() {
        return this.killThreads;
    }

    public int getThreadCheckThreads() {
        return this.threadCheckThreads;
    }

    public long getCheckThreadsEveryMillis() {
        return this.checkThreadsEveryMillis;
    }

    public int getMaxTaskMessageLength() {
        return this.maxTaskMessageLength;
    }

    public String getLogrotateCommand() {
        return this.logrotateCommand;
    }

    public String getLogrotateStateFile() {
        return this.logrotateStateFile;
    }

    public String getLogrotateConfDirectory() {
        return this.logrotateConfDirectory;
    }

    public String getLogrotateToDirectory() {
        return this.logrotateToDirectory;
    }

    public int getLogrotateMaxageDays() {
        return this.logrotateMaxageDays;
    }

    public int getLogrotateCount() {
        return this.logrotateCount;
    }

    public String getLogrotateDateformat() {
        return this.logrotateDateformat;
    }

    public String getLogrotateExtrasDateformat() {
        return this.logrotateExtrasDateformat;
    }

    public int getTailLogLinesToSave() {
        return this.tailLogLinesToSave;
    }

    public boolean isUseLocalDownloadService() {
        return this.useLocalDownloadService;
    }

    public long getLocalDownloadServiceTimeoutMillis() {
        return this.localDownloadServiceTimeoutMillis;
    }

    public Optional<Integer> getMaxTaskThreads() {
        return this.maxTaskThreads;
    }

    public String getDockerPrefix() {
        return this.dockerPrefix;
    }

    public int getDockerStopTimeout() {
        return this.dockerStopTimeout;
    }

    @JsonIgnore
    public Path getTaskDefinitionPath(String taskId) {
        return Paths.get(this.getGlobalTaskDefinitionDirectory(), new String[0]).resolve(MesosUtils.getSafeTaskIdForDirectory((String)taskId) + this.getGlobalTaskDefinitionSuffix());
    }

    public void setExecutorJavaLog(String executorJavaLog) {
        this.executorJavaLog = executorJavaLog;
    }

    public void setExecutorBashLog(String executorBashLog) {
        this.executorBashLog = executorBashLog;
    }

    public void setDefaultRunAsUser(String defaultRunAsUser) {
        this.defaultRunAsUser = defaultRunAsUser;
    }

    public void setTaskAppDirectory(String taskAppDirectory) {
        this.taskAppDirectory = taskAppDirectory;
    }

    public void setShutdownTimeoutWaitMillis(long shutdownTimeoutWaitMillis) {
        this.shutdownTimeoutWaitMillis = shutdownTimeoutWaitMillis;
    }

    public void setIdleExecutorShutdownWaitMillis(long idleExecutorShutdownWaitMillis) {
        this.idleExecutorShutdownWaitMillis = idleExecutorShutdownWaitMillis;
    }

    public void setStopDriverAfterMillis(long stopDriverAfterMillis) {
        this.stopDriverAfterMillis = stopDriverAfterMillis;
    }

    public void setGlobalTaskDefinitionDirectory(String globalTaskDefinitionDirectory) {
        this.globalTaskDefinitionDirectory = globalTaskDefinitionDirectory;
    }

    public void setGlobalTaskDefinitionSuffix(String globalTaskDefinitionSuffix) {
        this.globalTaskDefinitionSuffix = globalTaskDefinitionSuffix;
    }

    public void setHardKillAfterMillis(long hardKillAfterMillis) {
        this.hardKillAfterMillis = hardKillAfterMillis;
    }

    public void setKillThreads(int killThreads) {
        this.killThreads = killThreads;
    }

    public void setThreadCheckThreads(int threadCheckThreads) {
        this.threadCheckThreads = threadCheckThreads;
    }

    public void setCheckThreadsEveryMillis(long checkThreadsEveryMillis) {
        this.checkThreadsEveryMillis = checkThreadsEveryMillis;
    }

    public void setMaxTaskMessageLength(int maxTaskMessageLength) {
        this.maxTaskMessageLength = maxTaskMessageLength;
    }

    public void setLogrotateCommand(String logrotateCommand) {
        this.logrotateCommand = logrotateCommand;
    }

    public void setLogrotateStateFile(String logrotateStateFile) {
        this.logrotateStateFile = logrotateStateFile;
    }

    public void setLogrotateConfDirectory(String logrotateConfDirectory) {
        this.logrotateConfDirectory = logrotateConfDirectory;
    }

    public void setLogrotateToDirectory(String logrotateToDirectory) {
        this.logrotateToDirectory = logrotateToDirectory;
    }

    public void setLogrotateMaxageDays(int logrotateMaxageDays) {
        this.logrotateMaxageDays = logrotateMaxageDays;
    }

    public void setLogrotateCount(int logrotateCount) {
        this.logrotateCount = logrotateCount;
    }

    public void setLogrotateDateformat(String logrotateDateformat) {
        this.logrotateDateformat = logrotateDateformat;
    }

    public void setLogrotateExtrasDateformat(String logrotateExtrasDateformat) {
        this.logrotateExtrasDateformat = logrotateExtrasDateformat;
    }

    public void setTailLogLinesToSave(int tailLogLinesToSave) {
        this.tailLogLinesToSave = tailLogLinesToSave;
    }

    public void setUseLocalDownloadService(boolean useLocalDownloadService) {
        this.useLocalDownloadService = useLocalDownloadService;
    }

    public void setLocalDownloadServiceTimeoutMillis(long localDownloadServiceTimeoutMillis) {
        this.localDownloadServiceTimeoutMillis = localDownloadServiceTimeoutMillis;
    }

    public void setMaxTaskThreads(Optional<Integer> maxTaskThreads) {
        this.maxTaskThreads = maxTaskThreads;
    }

    public void setDockerPrefix(String dockerPrefix) {
        this.dockerPrefix = dockerPrefix;
    }

    public void setDockerStopTimeout(int dockerStopTimeout) {
        this.dockerStopTimeout = dockerStopTimeout;
    }

    public String getCgroupsMesosCpuTasksFormat() {
        return this.cgroupsMesosCpuTasksFormat;
    }

    public void setCgroupsMesosCpuTasksFormat(String cgroupsMesosCpuTasksFormat) {
        this.cgroupsMesosCpuTasksFormat = cgroupsMesosCpuTasksFormat;
    }

    public String getProcCgroupFormat() {
        return this.procCgroupFormat;
    }

    public void setProcCgroupFormat(String procCgroupFormat) {
        this.procCgroupFormat = procCgroupFormat;
    }

    public String getSwitchUserCommandFormat() {
        return this.switchUserCommandFormat;
    }

    public void setSwitchUserCommandFormat(String switchUserCommandFormat) {
        this.switchUserCommandFormat = switchUserCommandFormat;
    }

    public List<String> getArtifactSignatureVerificationCommand() {
        return this.artifactSignatureVerificationCommand;
    }

    public void setArtifactSignatureVerificationCommand(List<String> artifactSignatureVerificationCommand) {
        this.artifactSignatureVerificationCommand = artifactSignatureVerificationCommand;
    }

    public boolean isFailTaskOnInvalidArtifactSignature() {
        return this.failTaskOnInvalidArtifactSignature;
    }

    public void setFailTaskOnInvalidArtifactSignature(boolean failTaskOnInvalidArtifactSignature) {
        this.failTaskOnInvalidArtifactSignature = failTaskOnInvalidArtifactSignature;
    }

    public String getSignatureVerifyOut() {
        return this.signatureVerifyOut;
    }

    public void setSignatureVerifyOut(String signatureVerifyOut) {
        this.signatureVerifyOut = signatureVerifyOut;
    }

    public List<SingularityExecutorShellCommandDescriptor> getShellCommands() {
        return this.shellCommands;
    }

    public void setShellCommands(List<SingularityExecutorShellCommandDescriptor> shellCommands) {
        this.shellCommands = shellCommands;
    }

    public String getShellCommandOutFile() {
        return this.shellCommandOutFile;
    }

    public void setShellCommandOutFile(String shellCommandOutFile) {
        this.shellCommandOutFile = shellCommandOutFile;
    }

    public String getShellCommandPidFile() {
        return this.shellCommandPidFile;
    }

    public void setShellCommandPidFile(String shellCommandPidFile) {
        this.shellCommandPidFile = shellCommandPidFile;
    }

    public List<String> getShellCommandPrefix() {
        return this.shellCommandPrefix;
    }

    public void setShellCommandPrefix(List<String> shellCommandPrefix) {
        this.shellCommandPrefix = shellCommandPrefix;
    }

    public int getDockerClientTimeLimitSeconds() {
        return this.dockerClientTimeLimitSeconds;
    }

    public void setDockerClientTimeLimitSeconds(int dockerClientTimeLimitMs) {
        this.dockerClientTimeLimitSeconds = dockerClientTimeLimitMs;
    }

    public int getDockerClientConnectionPoolSize() {
        return this.dockerClientConnectionPoolSize;
    }

    public void setDockerClientConnectionPoolSize(int dockerClientConnectionPoolSize) {
        this.dockerClientConnectionPoolSize = dockerClientConnectionPoolSize;
    }

    public int getMaxDockerPullAttempts() {
        return this.maxDockerPullAttempts;
    }

    public void setMaxDockerPullAttempts(int maxDockerPullAttempts) {
        this.maxDockerPullAttempts = maxDockerPullAttempts;
    }

    public Optional<SingularityExecutorDockerAuthConfig> getDockerAuthConfig() {
        return this.dockerAuthConfig;
    }

    public void setDockerAuthConfig(Optional<SingularityExecutorDockerAuthConfig> dockerAuthConfig) {
        this.dockerAuthConfig = dockerAuthConfig;
    }

    public ThreadCheckerType getThreadCheckerType() {
        return this.threadCheckerType;
    }

    public void setThreadCheckerType(ThreadCheckerType threadCheckerType) {
        this.threadCheckerType = threadCheckerType;
    }

    public SingularityExecutorLogrotateFrequency getLogrotateFrequency() {
        return this.logrotateFrequency;
    }

    public void setLogrotateFrequency(SingularityExecutorLogrotateFrequency logrotateFrequency) {
        this.logrotateFrequency = logrotateFrequency;
    }

    public String getCronDirectory() {
        return this.cronDirectory;
    }

    public void setCronDirectory(String cronDirectory) {
        this.cronDirectory = cronDirectory;
    }

    public boolean isUseFileAttributes() {
        return this.useFileAttributes;
    }

    public SingularityExecutorConfiguration setUseFileAttributes(boolean useFileAttributes) {
        this.useFileAttributes = useFileAttributes;
        return this;
    }

    public LogrotateCompressionSettings getLogrotateCompressionSettings() {
        return this.logrotateCompressionSettings;
    }

    public void setLogrotateCompressionSettings(LogrotateCompressionSettings logrotateCompressionSettings) {
        this.logrotateCompressionSettings = logrotateCompressionSettings;
    }

    public long getInitialIdleExecutorShutdownWaitMillis() {
        return this.initialIdleExecutorShutdownWaitMillis;
    }

    public void setInitialIdleExecutorShutdownWaitMillis(long initialIdleExecutorShutdownWaitMillis) {
        this.initialIdleExecutorShutdownWaitMillis = initialIdleExecutorShutdownWaitMillis;
    }

    public String toString() {
        return "SingularityExecutorConfiguration{executorJavaLog='" + this.executorJavaLog + '\'' + ", executorBashLog='" + this.executorBashLog + '\'' + ", defaultRunAsUser='" + this.defaultRunAsUser + '\'' + ", taskAppDirectory='" + this.taskAppDirectory + '\'' + ", shutdownTimeoutWaitMillis=" + this.shutdownTimeoutWaitMillis + ", idleExecutorShutdownWaitMillis=" + this.idleExecutorShutdownWaitMillis + ", stopDriverAfterMillis=" + this.stopDriverAfterMillis + ", globalTaskDefinitionDirectory='" + this.globalTaskDefinitionDirectory + '\'' + ", globalTaskDefinitionSuffix='" + this.globalTaskDefinitionSuffix + '\'' + ", hardKillAfterMillis=" + this.hardKillAfterMillis + ", killThreads=" + this.killThreads + ", threadCheckThreads=" + this.threadCheckThreads + ", checkThreadsEveryMillis=" + this.checkThreadsEveryMillis + ", maxTaskMessageLength=" + this.maxTaskMessageLength + ", logrotateCommand='" + this.logrotateCommand + '\'' + ", logrotateStateFile='" + this.logrotateStateFile + '\'' + ", logrotateConfDirectory='" + this.logrotateConfDirectory + '\'' + ", logrotateToDirectory='" + this.logrotateToDirectory + '\'' + ", logrotateMaxageDays=" + this.logrotateMaxageDays + ", logrotateCount=" + this.logrotateCount + ", logrotateDateformat='" + this.logrotateDateformat + '\'' + ", logrotateExtrasDateformat='" + this.logrotateExtrasDateformat + '\'' + ", logrotateCompressionSettings=" + this.logrotateCompressionSettings + ", logrotateAdditionalFiles=" + this.logrotateAdditionalFiles + ", tailLogLinesToSave=" + this.tailLogLinesToSave + ", useLocalDownloadService=" + this.useLocalDownloadService + ", localDownloadServiceTimeoutMillis=" + this.localDownloadServiceTimeoutMillis + ", localDownloadServiceMaxConnections=" + this.localDownloadServiceMaxConnections + ", maxTaskThreads=" + this.maxTaskThreads + ", dockerPrefix='" + this.dockerPrefix + '\'' + ", dockerStopTimeout=" + this.dockerStopTimeout + ", cgroupsMesosCpuTasksFormat='" + this.cgroupsMesosCpuTasksFormat + '\'' + ", procCgroupFormat='" + this.procCgroupFormat + '\'' + ", switchUserCommandFormat='" + this.switchUserCommandFormat + '\'' + ", artifactSignatureVerificationCommand=" + this.artifactSignatureVerificationCommand + ", failTaskOnInvalidArtifactSignature=" + this.failTaskOnInvalidArtifactSignature + ", signatureVerifyOut='" + this.signatureVerifyOut + '\'' + ", shellCommands=" + this.shellCommands + ", shellCommandOutFile='" + this.shellCommandOutFile + '\'' + ", shellCommandPidPlaceholder='" + this.shellCommandPidPlaceholder + '\'' + ", shellCommandUserPlaceholder='" + this.shellCommandUserPlaceholder + '\'' + ", shellCommandPidFile='" + this.shellCommandPidFile + '\'' + ", shellCommandPrefix=" + this.shellCommandPrefix + ", dockerClientTimeLimitSeconds=" + this.dockerClientTimeLimitSeconds + ", dockerClientConnectionPoolSize=" + this.dockerClientConnectionPoolSize + ", maxDockerPullAttempts=" + this.maxDockerPullAttempts + ", dockerAuthConfig=" + this.dockerAuthConfig + ", threadCheckerType=" + (Object)((Object)this.threadCheckerType) + ", logrotateFrequency=" + this.logrotateFrequency + ", cronDirectory='" + this.cronDirectory + '\'' + ", useFileAttributes=" + this.useFileAttributes + "} " + super.toString();
    }
}

