/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor;

import com.github.jknack.handlebars.Template;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hubspot.singularity.executor.models.DockerContext;
import com.hubspot.singularity.executor.models.EnvironmentContext;
import com.hubspot.singularity.executor.models.LogrotateCronTemplateContext;
import com.hubspot.singularity.executor.models.LogrotateTemplateContext;
import com.hubspot.singularity.executor.models.RunnerContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@Singleton
public class TemplateManager {
    private final Template runnerTemplate;
    private final Template environmentTemplate;
    private final Template logrotateTemplate;
    private final Template logrotateCronTemplate;
    private final Template dockerTemplate;

    @Inject
    public TemplateManager(@Named(value="runner.sh") Template runnerTemplate, @Named(value="deploy.env") Template environmentTemplate, @Named(value="logrotate.conf") Template logrotateTemplate, @Named(value="logrotate.cron") Template logrotateCronTemplate, @Named(value="docker.sh") Template dockerTemplate) {
        this.runnerTemplate = runnerTemplate;
        this.environmentTemplate = environmentTemplate;
        this.logrotateTemplate = logrotateTemplate;
        this.logrotateCronTemplate = logrotateCronTemplate;
        this.dockerTemplate = dockerTemplate;
    }

    public void writeRunnerScript(Path destination, RunnerContext runnerContext) {
        this.writeTemplate(destination, this.runnerTemplate, runnerContext);
    }

    public void writeEnvironmentScript(Path destination, EnvironmentContext environmentContext) {
        this.writeTemplate(destination, this.environmentTemplate, environmentContext);
    }

    public void writeLogrotateFile(Path destination, LogrotateTemplateContext logRotateContext) {
        this.writeTemplate(destination, this.logrotateTemplate, logRotateContext);
    }

    public boolean writeCronEntryForLogrotate(Path destination, LogrotateCronTemplateContext logrotateCronTemplateContext) {
        this.writeTemplate(destination, this.logrotateCronTemplate, logrotateCronTemplateContext);
        File destinationFile = destination.toFile();
        return destinationFile.setExecutable(false, false) && destinationFile.setReadable(true, false) && destinationFile.setWritable(false, false) && destinationFile.setWritable(true);
    }

    public void writeDockerScript(Path destination, DockerContext dockerContext) {
        this.writeTemplate(destination, this.dockerTemplate, dockerContext);
    }

    private void writeTemplate(Path path, Template template, Object context) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            template.apply(context, (Writer)writer);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

