/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven.event.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.kencochrane.raven.event.interfaces.SentryInterface;

public class HttpInterface
implements SentryInterface {
    public static final String HTTP_INTERFACE = "sentry.interfaces.Http";
    private final String requestUrl;
    private final String method;
    private final Map<String, Collection<String>> parameters;
    private final String queryString;
    private final Map<String, String> cookies;
    private final String remoteAddr;
    private final String serverName;
    private final int serverPort;
    private final String localAddr;
    private final String localName;
    private final int localPort;
    private final String protocol;
    private final boolean secure;
    private final boolean asyncStarted;
    private final String authType;
    private final String remoteUser;
    private final Map<String, Collection<String>> headers;

    public HttpInterface(HttpServletRequest request) {
        this.requestUrl = request.getRequestURL().toString();
        this.method = request.getMethod();
        this.parameters = new HashMap<String, Collection<String>>();
        for (Map.Entry parameterMapEntry : request.getParameterMap().entrySet()) {
            this.parameters.put((String)parameterMapEntry.getKey(), (Collection<String>)Arrays.asList((Object[])parameterMapEntry.getValue()));
        }
        this.queryString = request.getQueryString();
        if (request.getCookies() != null) {
            this.cookies = new HashMap<String, String>();
            for (Cookie cookie : request.getCookies()) {
                this.cookies.put(cookie.getName(), cookie.getValue());
            }
        } else {
            this.cookies = Collections.emptyMap();
        }
        this.remoteAddr = request.getRemoteAddr();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.localAddr = request.getLocalAddr();
        this.localName = request.getLocalName();
        this.localPort = request.getLocalPort();
        this.protocol = request.getProtocol();
        this.secure = request.isSecure();
        this.asyncStarted = request.isAsyncStarted();
        this.authType = request.getAuthType();
        this.remoteUser = request.getRemoteUser();
        this.headers = new HashMap<String, Collection<String>>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            this.headers.put(headerName, Collections.list(request.getHeaders(headerName)));
        }
    }

    @Override
    public String getInterfaceName() {
        return HTTP_INTERFACE;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Collection<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Map<String, Collection<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String toString() {
        return "HttpInterface{requestUrl='" + this.requestUrl + '\'' + ", method='" + this.method + '\'' + ", queryString='" + this.queryString + '\'' + ", parameters=" + this.parameters + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpInterface that = (HttpInterface)o;
        if (this.asyncStarted != that.asyncStarted) {
            return false;
        }
        if (this.localPort != that.localPort) {
            return false;
        }
        if (this.secure != that.secure) {
            return false;
        }
        if (this.serverPort != that.serverPort) {
            return false;
        }
        if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) {
            return false;
        }
        if (!this.cookies.equals(that.cookies)) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (this.localAddr != null ? !this.localAddr.equals(that.localAddr) : that.localAddr != null) {
            return false;
        }
        if (this.localName != null ? !this.localName.equals(that.localName) : that.localName != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) {
            return false;
        }
        if (this.remoteAddr != null ? !this.remoteAddr.equals(that.remoteAddr) : that.remoteAddr != null) {
            return false;
        }
        if (this.remoteUser != null ? !this.remoteUser.equals(that.remoteUser) : that.remoteUser != null) {
            return false;
        }
        if (!this.requestUrl.equals(that.requestUrl)) {
            return false;
        }
        return !(this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null);
    }

    public int hashCode() {
        int result = this.requestUrl.hashCode();
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + this.parameters.hashCode();
        return result;
    }
}

