/*
 * Decompiled with CFR 0.152.
 */
package net.kencochrane.raven;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kencochrane.raven.Raven;
import net.kencochrane.raven.RavenFactory;
import net.kencochrane.raven.connection.AsyncConnection;
import net.kencochrane.raven.connection.Connection;
import net.kencochrane.raven.connection.HttpConnection;
import net.kencochrane.raven.connection.NoopConnection;
import net.kencochrane.raven.connection.OutputStreamConnection;
import net.kencochrane.raven.dsn.Dsn;
import net.kencochrane.raven.event.helper.HttpEventBuilderHelper;
import net.kencochrane.raven.event.interfaces.ExceptionInterface;
import net.kencochrane.raven.event.interfaces.HttpInterface;
import net.kencochrane.raven.event.interfaces.MessageInterface;
import net.kencochrane.raven.event.interfaces.StackTraceInterface;
import net.kencochrane.raven.event.interfaces.UserInterface;
import net.kencochrane.raven.marshaller.Marshaller;
import net.kencochrane.raven.marshaller.json.ExceptionInterfaceBinding;
import net.kencochrane.raven.marshaller.json.HttpInterfaceBinding;
import net.kencochrane.raven.marshaller.json.JsonMarshaller;
import net.kencochrane.raven.marshaller.json.MessageInterfaceBinding;
import net.kencochrane.raven.marshaller.json.StackTraceInterfaceBinding;
import net.kencochrane.raven.marshaller.json.UserInterfaceBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRavenFactory
extends RavenFactory {
    public static final String NAIVE_PROTOCOL = "naive";
    public static final String COMPRESSION_OPTION = "raven.compression";
    public static final String TIMEOUT_OPTION = "raven.timeout";
    public static final String ASYNC_OPTION = "raven.async";
    public static final String GRACEFUL_SHUTDOWN_OPTION = "raven.async.gracefulshutdown";
    public static final String MAX_THREADS_OPTION = "raven.async.threads";
    public static final String PRIORITY_OPTION = "raven.async.priority";
    public static final String QUEUE_SIZE_OPTION = "raven.async.queuesize";
    public static final String HIDE_COMMON_FRAMES_OPTION = "raven.stacktrace.hidecommon";
    private static final Logger logger = LoggerFactory.getLogger(DefaultRavenFactory.class);
    private static final String FALSE = Boolean.FALSE.toString();

    @Override
    public Raven createRavenInstance(Dsn dsn) {
        Raven raven = new Raven();
        raven.setConnection(this.createConnection(dsn));
        try {
            Class.forName("javax.servlet.Servlet", false, this.getClass().getClassLoader());
            raven.addBuilderHelper(new HttpEventBuilderHelper());
        }
        catch (ClassNotFoundException e) {
            logger.debug("It seems that the current environment doesn't provide access to servlets.");
        }
        return raven;
    }

    protected Connection createConnection(Dsn dsn) {
        Connection connection;
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            logger.info("Using an HTTP connection to Sentry.");
            connection = this.createHttpConnection(dsn);
        } else if (protocol.equalsIgnoreCase("out")) {
            logger.info("Using StdOut to send events.");
            connection = this.createStdOutConnection(dsn);
        } else if (protocol.equalsIgnoreCase("noop")) {
            logger.info("Using noop to send events.");
            connection = new NoopConnection();
        } else {
            throw new IllegalStateException("Couldn't create a connection for the protocol '" + protocol + "'");
        }
        if (!FALSE.equalsIgnoreCase(dsn.getOptions().get(ASYNC_OPTION))) {
            connection = this.createAsyncConnection(dsn, connection);
        }
        return connection;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        int maxThreads = dsn.getOptions().containsKey(MAX_THREADS_OPTION) ? Integer.parseInt(dsn.getOptions().get(MAX_THREADS_OPTION)) : Runtime.getRuntime().availableProcessors();
        int priority = dsn.getOptions().containsKey(PRIORITY_OPTION) ? Integer.parseInt(dsn.getOptions().get(PRIORITY_OPTION)) : 1;
        LinkedBlockingDeque<Runnable> queue = dsn.getOptions().containsKey(QUEUE_SIZE_OPTION) ? new LinkedBlockingDeque(Integer.parseInt(dsn.getOptions().get(QUEUE_SIZE_OPTION))) : new LinkedBlockingDeque<Runnable>();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(priority), new ThreadPoolExecutor.DiscardOldestPolicy());
        boolean gracefulShutdown = !FALSE.equalsIgnoreCase(dsn.getOptions().get(GRACEFUL_SHUTDOWN_OPTION));
        return new AsyncConnection(connection, executorService, gracefulShutdown);
    }

    protected Connection createHttpConnection(Dsn dsn) {
        URL sentryApiUrl = HttpConnection.getSentryApiUrl(dsn.getUri(), dsn.getProjectId());
        HttpConnection httpConnection = new HttpConnection(sentryApiUrl, dsn.getPublicKey(), dsn.getSecretKey());
        httpConnection.setMarshaller(this.createMarshaller(dsn));
        httpConnection.setBypassSecurity(dsn.getProtocolSettings().contains(NAIVE_PROTOCOL));
        if (dsn.getOptions().containsKey(TIMEOUT_OPTION)) {
            httpConnection.setTimeout(Integer.parseInt(dsn.getOptions().get(TIMEOUT_OPTION)));
        }
        return httpConnection;
    }

    protected Connection createStdOutConnection(Dsn dsn) {
        OutputStreamConnection stdOutConnection = new OutputStreamConnection(System.out);
        stdOutConnection.setMarshaller(this.createMarshaller(dsn));
        return stdOutConnection;
    }

    protected Marshaller createMarshaller(Dsn dsn) {
        JsonMarshaller marshaller = new JsonMarshaller();
        StackTraceInterfaceBinding stackTraceBinding = new StackTraceInterfaceBinding();
        stackTraceBinding.setRemoveCommonFramesWithEnclosing(!FALSE.equalsIgnoreCase(dsn.getOptions().get(HIDE_COMMON_FRAMES_OPTION)));
        stackTraceBinding.setNotInAppFrames(this.getNotInAppFrames());
        marshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceBinding);
        marshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceBinding));
        marshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding());
        marshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        HttpInterfaceBinding httpBinding = new HttpInterfaceBinding();
        marshaller.addInterfaceBinding(HttpInterface.class, httpBinding);
        marshaller.setCompression(!FALSE.equalsIgnoreCase(dsn.getOptions().get(COMPRESSION_OPTION)));
        return marshaller;
    }

    protected Collection<String> getNotInAppFrames() {
        return Arrays.asList("com.sun.", "java.", "javax.", "org.omg.", "sun.", "junit.", "com.intellij.rt.");
    }

    protected static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        private DaemonThreadFactory(int priority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "raven-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

