/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.Duration;
import io.dropwizard.validation.MaxDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MaxDurationValidator
implements ConstraintValidator<MaxDuration, Duration> {
    private long maxQty;
    private TimeUnit maxUnit;

    @Override
    public void initialize(MaxDuration constraintAnnotation) {
        this.maxQty = constraintAnnotation.value();
        this.maxUnit = constraintAnnotation.unit();
    }

    @Override
    public boolean isValid(Duration value, ConstraintValidatorContext context) {
        return value == null || value.toNanoseconds() <= this.maxUnit.toNanos(this.maxQty);
    }
}

