/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStream
extends AbstractIterator<LogMessage>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LogStream.class);
    private final LogReader reader;
    private volatile boolean closed;

    LogStream(InputStream stream) {
        this.reader = new LogReader(stream);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            log.warn(this + " not closed properly");
            this.close();
        }
    }

    @Override
    protected LogMessage computeNext() {
        LogMessage message;
        try {
            message = this.reader.nextMessage();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        if (message == null) {
            return (LogMessage)this.endOfData();
        }
        return message;
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    public String readFully() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            stringBuilder.append(Charsets.UTF_8.decode(((LogMessage)this.next()).content()));
        }
        return stringBuilder.toString();
    }

    public void attach(OutputStream stdout, OutputStream stderr) throws IOException {
        try (WritableByteChannel stdoutChannel = Channels.newChannel(stdout);
             WritableByteChannel stderrChannel = Channels.newChannel(stderr);){
            block22: while (this.hasNext()) {
                LogMessage message = (LogMessage)this.next();
                switch (message.stream()) {
                    case STDOUT: {
                        stdoutChannel.write(message.content());
                        continue block22;
                    }
                    case STDERR: {
                        stderrChannel.write(message.content());
                        continue block22;
                    }
                }
            }
        }
    }
}

