/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class S3UploadMetadata {
    private final String directory;
    private final String fileGlob;
    private final String s3Bucket;
    private final String s3KeyFormat;
    private final boolean finished;
    private final Optional<String> onFinishGlob;
    private final Optional<Integer> pid;
    private final Optional<String> s3AccessKey;
    private final Optional<String> s3SecretKey;
    private final Optional<Long> finishedAfterMillisWithoutNewFile;
    private final Optional<String> s3StorageClass;
    private final Optional<Long> applyStorageClassIfOverBytes;
    private final Optional<Boolean> uploadImmediately;

    @JsonCreator
    public S3UploadMetadata(@JsonProperty(value="directory") String directory, @JsonProperty(value="fileGlob") String fileGlob, @JsonProperty(value="s3Bucket") String s3Bucket, @JsonProperty(value="s3KeyFormat") String s3KeyFormat, @JsonProperty(value="finished") boolean finished, @JsonProperty(value="onFinishGlob") Optional<String> onFinishGlob, @JsonProperty(value="pid") Optional<Integer> pid, @JsonProperty(value="s3AccessKey") Optional<String> s3AccessKey, @JsonProperty(value="s3SecretKey") Optional<String> s3SecretKey, @JsonProperty(value="finishedAfterMillisWithoutNewFile") Optional<Long> finishedAfterMillisWithoutNewFile, @JsonProperty(value="storageClass") Optional<String> s3StorageClass, @JsonProperty(value="applyStorageClassIfOverBytes") Optional<Long> applyStorageClassIfOverBytes, @JsonProperty(value="uploadImmediately") Optional<Boolean> uploadImmediately) {
        Preconditions.checkNotNull(directory);
        Preconditions.checkNotNull(fileGlob);
        Preconditions.checkNotNull(s3Bucket);
        Preconditions.checkNotNull(s3KeyFormat);
        this.directory = directory;
        this.fileGlob = fileGlob;
        this.s3Bucket = s3Bucket;
        this.s3KeyFormat = s3KeyFormat;
        this.finished = finished;
        this.pid = pid;
        this.s3AccessKey = s3AccessKey;
        this.s3SecretKey = s3SecretKey;
        this.onFinishGlob = onFinishGlob;
        this.s3StorageClass = s3StorageClass;
        this.finishedAfterMillisWithoutNewFile = finishedAfterMillisWithoutNewFile;
        this.applyStorageClassIfOverBytes = applyStorageClassIfOverBytes;
        this.uploadImmediately = uploadImmediately;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        result = 31 * result + (this.fileGlob == null ? 0 : this.fileGlob.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S3UploadMetadata other = (S3UploadMetadata)obj;
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            return false;
        }
        return !(this.fileGlob == null ? other.fileGlob != null : !this.fileGlob.equals(other.fileGlob));
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileGlob() {
        return this.fileGlob;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3KeyFormat() {
        return this.s3KeyFormat;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Optional<Integer> getPid() {
        return this.pid;
    }

    public Optional<String> getS3AccessKey() {
        return this.s3AccessKey;
    }

    public Optional<String> getS3SecretKey() {
        return this.s3SecretKey;
    }

    public Optional<String> getOnFinishGlob() {
        return this.onFinishGlob;
    }

    public Optional<Long> getFinishedAfterMillisWithoutNewFile() {
        return this.finishedAfterMillisWithoutNewFile;
    }

    public Optional<String> getS3StorageClass() {
        return this.s3StorageClass;
    }

    public Optional<Long> getApplyStorageClassIfOverBytes() {
        return this.applyStorageClassIfOverBytes;
    }

    public Optional<Boolean> getUploadImmediately() {
        return this.uploadImmediately;
    }

    public String toString() {
        return "S3UploadMetadata [directory=" + this.directory + ", fileGlob=" + this.fileGlob + ", s3Bucket=" + this.s3Bucket + ", s3KeyFormat=" + this.s3KeyFormat + ", finished=" + this.finished + ", onFinishGlob=" + this.onFinishGlob + ", pid=" + this.pid + ", s3AccessKey=" + this.s3AccessKey + ", s3SecretKey=" + this.s3SecretKey + ", finishedAfterMillisWithoutNewFile=" + this.finishedAfterMillisWithoutNewFile + ", s3StorageClass=" + this.s3StorageClass + ", applyStorageClassIfOverBytes=" + this.applyStorageClassIfOverBytes + ", uploadImmediately=" + this.uploadImmediately + "]";
    }
}

