/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.runner.base.shared;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.runner.base.shared.Signal;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);
    private final Optional<Logger> log;

    public ProcessUtils() {
        this(null);
    }

    public ProcessUtils(@Nullable Logger log) {
        this.log = Optional.fromNullable(log);
    }

    public ProcessResult sendSignal(Signal signal, int pid) {
        long start = System.currentTimeMillis();
        if (this.log.isPresent()) {
            String logLine = String.format("Signaling %s (%s) to process %s", new Object[]{signal, signal.getCode(), pid});
            if (signal == Signal.CHECK) {
                this.log.get().trace(logLine);
            } else {
                this.log.get().info(logLine);
            }
        }
        if (signal != Signal.CHECK) {
            LOG.debug("Signaling {} ({}) to process {}", new Object[]{signal, signal.getCode(), pid});
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("kill", String.format("-%s", signal.getCode()), Integer.toString(pid));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            int exitCode = p.waitFor();
            String output = CharStreams.toString(new InputStreamReader(p.getInputStream(), Charsets.UTF_8));
            Closeables.closeQuietly(p.getInputStream());
            if (this.log.isPresent()) {
                this.log.get().trace("Kill signal process for {} got exit code {} after {}", pid, exitCode, JavaUtils.duration(start));
            }
            return new ProcessResult(exitCode, output.trim());
        }
        catch (IOException | InterruptedException e) {
            throw Throwables.propagate(e);
        }
    }

    public int getUnixPID(Process process) {
        Preconditions.checkArgument(process.getClass().getName().equals("java.lang.UNIXProcess"));
        Class<?> clazz = process.getClass();
        try {
            Field field = clazz.getDeclaredField("pid");
            field.setAccessible(true);
            Object pidObject = field.get(process);
            return (Integer)pidObject;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw Throwables.propagate(e);
        }
    }

    public boolean doesProcessExist(int pid) {
        ProcessResult processResult = this.sendSignal(Signal.CHECK, pid);
        return processResult.getExitCode() == 0 || !processResult.output.contains("No such process");
    }

    public static class ProcessResult {
        private final int exitCode;
        private final String output;

        public ProcessResult(int exitCode, String output) {
            this.exitCode = exitCode;
            this.output = output;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public String toString() {
            return "ProcessResult [exitCode=" + this.exitCode + ", output=" + this.output + "]";
        }
    }
}

