/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.singularity.MetadataLevel;
import com.wordnik.swagger.annotations.ApiModelProperty;

public class SingularityTaskMetadataRequest {
    private final String type;
    private final String title;
    private final Optional<String> message;
    private final Optional<MetadataLevel> level;

    @JsonCreator
    public SingularityTaskMetadataRequest(@JsonProperty(value="type") String type, @JsonProperty(value="title") String title, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="level") Optional<MetadataLevel> level) {
        Preconditions.checkNotNull(type);
        Preconditions.checkState(!type.contains("/"));
        this.type = type;
        this.title = title;
        this.message = message;
        this.level = level;
    }

    @ApiModelProperty(required=true, value="A type to be associated with this metadata")
    public String getType() {
        return this.type;
    }

    @ApiModelProperty(required=true, value="A title to be associated with this metadata")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(required=false, value="An optional message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @ApiModelProperty(required=false, value="Level of metadata, can be INFO, WARN, or ERROR")
    public Optional<MetadataLevel> getLevel() {
        return this.level;
    }

    public String toString() {
        return "SingularityTaskMetadataRequest{type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", message=" + this.message + ", level=" + this.level + '}';
    }
}

