/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityS3LogMetadata;
import com.hubspot.singularity.api.ContinuationToken;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityS3SearchResult {
    private final Map<String, ContinuationToken> continuationTokens;
    private final boolean lastPage;
    private final List<SingularityS3LogMetadata> results;

    public static SingularityS3SearchResult empty() {
        return new SingularityS3SearchResult(Collections.emptyMap(), false, Collections.emptyList());
    }

    @JsonCreator
    public SingularityS3SearchResult(@JsonProperty(value="continuationTokens") Map<String, ContinuationToken> continuationTokens, @JsonProperty(value="lastPage") boolean lastPage, @JsonProperty(value="results") List<SingularityS3LogMetadata> results) {
        this.continuationTokens = continuationTokens;
        this.lastPage = lastPage;
        this.results = results;
    }

    @ApiModelProperty(required=false, value="S3 continuation tokens, return these to Singularity to continue searching subsequent pages of results")
    public Map<String, ContinuationToken> getContinuationTokens() {
        return this.continuationTokens;
    }

    @ApiModelProperty(required=true, value="If true, there are no further results for any bucket + prefix being searched")
    public boolean isLastPage() {
        return this.lastPage;
    }

    @ApiModelProperty(value="List of S3 log metadata")
    public List<SingularityS3LogMetadata> getResults() {
        return this.results;
    }

    public String toString() {
        return "SingularityS3SearchResult{continuationTokens=" + this.continuationTokens + ", lastPage=" + this.lastPage + ", results=" + this.results + '}';
    }
}

