/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.api.ContinuationToken;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityS3SearchRequest {
    private final Map<String, List<String>> requestsAndDeploys;
    private final List<String> taskIds;
    private final Optional<Long> start;
    private final Optional<Long> end;
    private final boolean excludeMetadata;
    private final boolean listOnly;
    private final Optional<Integer> maxPerPage;
    private final Map<String, ContinuationToken> continuationTokens;

    @JsonCreator
    public SingularityS3SearchRequest(@JsonProperty(value="requestsAndDeploys") Map<String, List<String>> requestsAndDeploys, @JsonProperty(value="taskIds") List<String> taskIds, @JsonProperty(value="start") Optional<Long> start, @JsonProperty(value="end") Optional<Long> end, @JsonProperty(value="excludeMetadata") boolean excludeMetadata, @JsonProperty(value="listOnly") boolean listOnly, @JsonProperty(value="maxPerPage") Optional<Integer> maxPerPage, @JsonProperty(value="continuationTokens") Map<String, ContinuationToken> continuationTokens) {
        this.requestsAndDeploys = requestsAndDeploys != null ? requestsAndDeploys : Collections.emptyMap();
        this.taskIds = taskIds != null ? taskIds : Collections.emptyList();
        this.start = start;
        this.end = end;
        this.excludeMetadata = excludeMetadata;
        this.listOnly = listOnly;
        this.maxPerPage = maxPerPage;
        this.continuationTokens = continuationTokens != null ? continuationTokens : Collections.emptyMap();
    }

    @ApiModelProperty(required=false, value="A map of request IDs to a list of deploy ids to search")
    public Map<String, List<String>> getRequestsAndDeploys() {
        return this.requestsAndDeploys;
    }

    @ApiModelProperty(required=false, value="A list of task IDs to search for")
    public List<String> getTaskIds() {
        return this.taskIds;
    }

    @ApiModelProperty(required=false, value="Start timestamp (millis, 13 digit)")
    public Optional<Long> getStart() {
        return this.start;
    }

    @ApiModelProperty(required=false, value="End timestamp (millis, 13 digit)")
    public Optional<Long> getEnd() {
        return this.end;
    }

    @ApiModelProperty(required=false, value="if true, do not query for custom start/end time metadata")
    public boolean isExcludeMetadata() {
        return this.excludeMetadata;
    }

    @ApiModelProperty(required=false, value="If true, do not generate download/get urls, only list objects")
    public boolean isListOnly() {
        return this.listOnly;
    }

    @ApiModelProperty(required=false, value="Target number of results to return")
    public Optional<Integer> getMaxPerPage() {
        return this.maxPerPage;
    }

    @ApiModelProperty(required=false, value="S3 continuation tokens, return these to Singularity to continue searching subsequent pages of results")
    public Map<String, ContinuationToken> getContinuationTokens() {
        return this.continuationTokens;
    }

    public String toString() {
        return "SingularityS3SearchRequest{requestsAndDeploys=" + this.requestsAndDeploys + ", taskIds=" + this.taskIds + ", start=" + this.start + ", end=" + this.end + ", excludeMetadata=" + this.excludeMetadata + ", listOnly=" + this.listOnly + ", maxPerPage=" + this.maxPerPage + ", continuationTokens=" + this.continuationTokens + '}';
    }
}

