/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SingularityPriorityFreeze {
    private final double minimumPriorityLevel;
    private final boolean killTasks;
    private final Optional<String> message;
    private final Optional<String> actionId;

    @JsonCreator
    public SingularityPriorityFreeze(@JsonProperty(value="minimumPriorityLevel") double minimumPriorityLevel, @JsonProperty(value="killTasks") boolean killTasks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId) {
        this.minimumPriorityLevel = minimumPriorityLevel;
        this.killTasks = killTasks;
        this.message = message;
        this.actionId = actionId;
    }

    @ApiModelProperty(required=true, value="Kill (if killTasks is true) or do not launch (if killTasks is false) tasks below this priority level")
    public double getMinimumPriorityLevel() {
        return this.minimumPriorityLevel;
    }

    @ApiModelProperty(required=true, value="If true, kill currently running tasks, and do not launch new tasks below the minimumPriorityLevel. If false, do not launch new tasks below minimumPriorityLevel")
    public boolean isKillTasks() {
        return this.killTasks;
    }

    @ApiModelProperty(required=false, value="An optional message/reason for creating the priority kill")
    public Optional<String> getMessage() {
        return this.message;
    }

    @ApiModelProperty(required=false, value="A unique ID for this priority kill")
    public Optional<String> getActionId() {
        return this.actionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityPriorityFreeze that = (SingularityPriorityFreeze)o;
        return Double.compare(that.minimumPriorityLevel, this.minimumPriorityLevel) == 0 && this.killTasks == that.killTasks && Objects.equals(this.message, that.message) && Objects.equals(this.actionId, that.actionId);
    }

    public int hashCode() {
        return Objects.hash(this.minimumPriorityLevel, this.killTasks, this.message, this.actionId);
    }

    public String toString() {
        return "SingularityPriorityFreeze{minimumPriorityLevel=" + this.minimumPriorityLevel + ", killTasks=" + this.killTasks + ", message=" + this.message + ", actionId=" + this.actionId + '}';
    }
}

