/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityShellCommand;
import com.wordnik.swagger.annotations.ApiModelProperty;

public class SingularityKillTaskRequest {
    private final Optional<String> message;
    private final Optional<Boolean> override;
    private final Optional<String> actionId;
    private final Optional<Boolean> waitForReplacementTask;
    private final Optional<SingularityShellCommand> runShellCommandBeforeKill;

    @JsonCreator
    public SingularityKillTaskRequest(@JsonProperty(value="override") Optional<Boolean> override, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="waitForReplacementTask") Optional<Boolean> waitForReplacementTask, @JsonProperty(value="runShellCommandBeforeKill") Optional<SingularityShellCommand> runShellCommandBeforeKill) {
        this.override = override;
        this.message = message;
        this.actionId = actionId;
        this.waitForReplacementTask = waitForReplacementTask;
        this.runShellCommandBeforeKill = runShellCommandBeforeKill;
    }

    @ApiModelProperty(required=false, value="A message to show to users about why this action was taken")
    public Optional<String> getMessage() {
        return this.message;
    }

    @ApiModelProperty(required=false, value="An id to associate with this action for metadata purposes")
    public Optional<String> getActionId() {
        return this.actionId;
    }

    @ApiModelProperty(required=false, value="If set to true, instructs the executor to attempt to immediately kill the task, rather than waiting gracefully")
    public Optional<Boolean> getOverride() {
        return this.override;
    }

    @ApiModelProperty(required=false, value="If set to true, treats this task kill as a bounce - launching another task and waiting for it to become healthy")
    public Optional<Boolean> getWaitForReplacementTask() {
        return this.waitForReplacementTask;
    }

    @ApiModelProperty(required=false, value="Attempt to run this shell command on each task before it is shut down")
    public Optional<SingularityShellCommand> getRunShellCommandBeforeKill() {
        return this.runShellCommandBeforeKill;
    }

    public String toString() {
        return "SingularityKillTaskRequest{message=" + this.message + ", override=" + this.override + ", actionId=" + this.actionId + ", waitForReplacementTask=" + this.waitForReplacementTask + ", runShellCommandBeforeKill=" + this.runShellCommandBeforeKill + '}';
    }
}

