/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class SingularityTaskHistoryUpdate
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskHistoryUpdate> {
    private final long timestamp;
    private final ExtendedTaskState taskState;
    private final Optional<String> statusMessage;
    private final Optional<String> statusReason;
    private final Set<SingularityTaskHistoryUpdate> previous;

    public static Optional<SingularityTaskHistoryUpdate> getUpdate(Iterable<SingularityTaskHistoryUpdate> updates, final ExtendedTaskState taskState) {
        return Iterables.tryFind(updates, new Predicate<SingularityTaskHistoryUpdate>(){

            @Override
            public boolean apply(@Nonnull SingularityTaskHistoryUpdate input) {
                return input.getTaskState() == taskState;
            }
        });
    }

    public static SimplifiedTaskState getCurrentState(Iterable<SingularityTaskHistoryUpdate> updates) {
        SimplifiedTaskState state = SimplifiedTaskState.UNKNOWN;
        if (updates == null) {
            return state;
        }
        for (SingularityTaskHistoryUpdate update : updates) {
            if (update.getTaskState().isDone()) {
                return SimplifiedTaskState.DONE;
            }
            if (update.getTaskState() == ExtendedTaskState.TASK_RUNNING) {
                state = SimplifiedTaskState.RUNNING;
                continue;
            }
            if (state != SimplifiedTaskState.UNKNOWN) continue;
            state = SimplifiedTaskState.WAITING;
        }
        return state;
    }

    public SingularityTaskHistoryUpdate(SingularityTaskId taskId, long timestamp, ExtendedTaskState taskState, Optional<String> statusMessage, Optional<String> statusReason) {
        this(taskId, timestamp, taskState, statusMessage, statusReason, Collections.emptySet());
    }

    @JsonCreator
    public SingularityTaskHistoryUpdate(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskState") ExtendedTaskState taskState, @JsonProperty(value="statusMessage") Optional<String> statusMessage, @JsonProperty(value="statusReason") Optional<String> statusReason, @JsonProperty(value="previous") Set<SingularityTaskHistoryUpdate> previous) {
        super(taskId);
        this.timestamp = timestamp;
        this.taskState = taskState;
        this.statusMessage = statusMessage;
        this.statusReason = statusReason;
        this.previous = previous != null ? previous : Collections.emptySet();
    }

    public SingularityTaskHistoryUpdate withPrevious(SingularityTaskHistoryUpdate previousUpdate) {
        Set<SingularityTaskHistoryUpdate> newPreviousUpdates = this.getFlattenedPreviousUpdates(this);
        newPreviousUpdates.add(previousUpdate.withoutPrevious());
        newPreviousUpdates.addAll(this.getFlattenedPreviousUpdates(previousUpdate));
        return new SingularityTaskHistoryUpdate(this.getTaskId(), this.timestamp, this.taskState, this.statusMessage, this.statusReason, newPreviousUpdates);
    }

    private Set<SingularityTaskHistoryUpdate> getFlattenedPreviousUpdates(SingularityTaskHistoryUpdate update) {
        HashSet<SingularityTaskHistoryUpdate> previousUpdates = new HashSet<SingularityTaskHistoryUpdate>();
        for (SingularityTaskHistoryUpdate previousUpdate : update.getPrevious()) {
            previousUpdates.add(previousUpdate.withoutPrevious());
            previousUpdates.addAll(this.getFlattenedPreviousUpdates(previousUpdate));
        }
        return previousUpdates;
    }

    public SingularityTaskHistoryUpdate withoutPrevious() {
        return new SingularityTaskHistoryUpdate(this.getTaskId(), this.timestamp, this.taskState, this.statusMessage, this.statusReason, Collections.emptySet());
    }

    @Override
    public int compareTo(SingularityTaskHistoryUpdate o) {
        return ComparisonChain.start().compare(this.taskState.ordinal(), o.getTaskState().ordinal()).compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)o.getTaskId().getId()), (Comparable<?>)((Object)this.getTaskId().getId())).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskHistoryUpdate that = (SingularityTaskHistoryUpdate)o;
        return this.timestamp == that.timestamp && this.taskState == that.taskState && Objects.equals(this.statusMessage, that.statusMessage) && Objects.equals(this.statusReason, that.statusReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.taskState, this.statusMessage, this.statusReason});
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ExtendedTaskState getTaskState() {
        return this.taskState;
    }

    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    public Optional<String> getStatusReason() {
        return this.statusReason;
    }

    public Set<SingularityTaskHistoryUpdate> getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "SingularityTaskHistoryUpdate[timestamp=" + this.timestamp + ", taskState=" + (Object)((Object)this.taskState) + ", statusMessage=" + this.statusMessage + ", statusReason=" + this.statusReason + ", previous=" + this.previous + ']';
    }

    public static enum SimplifiedTaskState {
        UNKNOWN,
        WAITING,
        RUNNING,
        DONE;

    }
}

