/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import java.util.Objects;

public class SingularityTaskHealthcheckResult
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskHealthcheckResult> {
    private final Optional<Integer> statusCode;
    private final Optional<Long> durationMillis;
    private final Optional<String> responseBody;
    private final Optional<String> errorMessage;
    private final boolean startup;
    private final long timestamp;

    @JsonCreator
    public SingularityTaskHealthcheckResult(@JsonProperty(value="statusCode") Optional<Integer> statusCode, @JsonProperty(value="duration") Optional<Long> durationMillis, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="responseBody") Optional<String> responseBody, @JsonProperty(value="errorMessage") Optional<String> errorMessage, @JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="startup") Optional<Boolean> startup) {
        super(taskId);
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
        this.durationMillis = durationMillis;
        this.timestamp = timestamp;
        this.responseBody = responseBody;
        this.startup = startup.or(false);
    }

    @Override
    public int compareTo(SingularityTaskHealthcheckResult o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)o.getTaskId().getId()), (Comparable<?>)((Object)this.getTaskId().getId())).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskHealthcheckResult that = (SingularityTaskHealthcheckResult)o;
        return this.startup == that.startup && this.timestamp == that.timestamp && Objects.equals(this.statusCode, that.statusCode) && Objects.equals(this.durationMillis, that.durationMillis) && Objects.equals(this.responseBody, that.responseBody) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.durationMillis, this.responseBody, this.errorMessage, this.startup, this.timestamp);
    }

    public Optional<Integer> getStatusCode() {
        return this.statusCode;
    }

    public Optional<Long> getDurationMillis() {
        return this.durationMillis;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getResponseBody() {
        return this.responseBody;
    }

    public boolean isStartup() {
        return this.startup;
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.getErrorMessage().isPresent() || this.getStatusCode().isPresent() && !JavaUtils.isHttpSuccess(this.getStatusCode().get());
    }

    public String toString() {
        return "SingularityTaskHealthcheckResult{statusCode=" + this.statusCode + ", durationMillis=" + this.durationMillis + ", responseBody=" + this.responseBody + ", errorMessage=" + this.errorMessage + ", startup=" + this.startup + ", timestamp=" + this.timestamp + "} " + super.toString();
    }
}

