/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.singularity.RequestType;
import com.hubspot.singularity.ScheduleType;
import com.hubspot.singularity.SingularityEmailDestination;
import com.hubspot.singularity.SingularityEmailType;
import com.hubspot.singularity.SingularityRequest;
import com.hubspot.singularity.SlavePlacement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SingularityRequestBuilder {
    private final String id;
    private final RequestType requestType;
    private Optional<List<String>> owners;
    private Optional<Integer> numRetriesOnFailure;
    private Optional<String> schedule;
    private Optional<String> quartzSchedule;
    private Optional<String> scheduleTimeZone;
    private Optional<ScheduleType> scheduleType;
    private Optional<Long> killOldNonLongRunningTasksAfterMillis;
    private Optional<Long> taskExecutionTimeLimitMillis;
    private Optional<Long> scheduledExpectedRuntimeMillis;
    private Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule;
    private Optional<Integer> instances;
    private Optional<Boolean> skipHealthchecks;
    private Optional<Boolean> rackSensitive;
    private Optional<List<String>> rackAffinity;
    private Optional<SlavePlacement> slavePlacement;
    private Optional<Map<String, String>> requiredSlaveAttributes;
    private Optional<Map<String, String>> allowedSlaveAttributes;
    private Optional<Boolean> loadBalanced;
    private Optional<String> requiredRole;
    private Optional<String> group;
    private Optional<Set<String>> readWriteGroups;
    private Optional<Set<String>> readOnlyGroups;
    private Optional<Boolean> bounceAfterScale;
    private Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides;
    private Optional<Boolean> hideEvenNumberAcrossRacksHint;
    private Optional<String> taskLogErrorRegex;
    private Optional<Boolean> taskLogErrorRegexCaseSensitive;
    private Optional<Double> taskPriorityLevel;
    private Optional<Integer> maxTasksPerOffer;
    private Optional<Boolean> allowBounceToSameHost;

    public SingularityRequestBuilder(String id, RequestType requestType) {
        this.id = Preconditions.checkNotNull(id, "id cannot be null");
        this.requestType = Preconditions.checkNotNull(requestType, "requestType cannot be null");
        this.owners = Optional.absent();
        this.numRetriesOnFailure = Optional.absent();
        this.schedule = Optional.absent();
        this.scheduleType = Optional.absent();
        this.killOldNonLongRunningTasksAfterMillis = Optional.absent();
        this.taskExecutionTimeLimitMillis = Optional.absent();
        this.instances = Optional.absent();
        this.rackSensitive = Optional.absent();
        this.loadBalanced = Optional.absent();
        this.quartzSchedule = Optional.absent();
        this.scheduleTimeZone = Optional.absent();
        this.rackAffinity = Optional.absent();
        this.slavePlacement = Optional.absent();
        this.requiredSlaveAttributes = Optional.absent();
        this.allowedSlaveAttributes = Optional.absent();
        this.scheduledExpectedRuntimeMillis = Optional.absent();
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = Optional.absent();
        this.group = Optional.absent();
        this.readWriteGroups = Optional.absent();
        this.readOnlyGroups = Optional.absent();
        this.bounceAfterScale = Optional.absent();
        this.emailConfigurationOverrides = Optional.absent();
        this.skipHealthchecks = Optional.absent();
        this.hideEvenNumberAcrossRacksHint = Optional.absent();
        this.taskLogErrorRegex = Optional.absent();
        this.taskLogErrorRegexCaseSensitive = Optional.absent();
        this.taskPriorityLevel = Optional.absent();
        this.maxTasksPerOffer = Optional.absent();
        this.allowBounceToSameHost = Optional.absent();
        this.requiredRole = Optional.absent();
    }

    public SingularityRequest build() {
        return new SingularityRequest(this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.instances, this.rackSensitive, this.loadBalanced, this.killOldNonLongRunningTasksAfterMillis, this.taskExecutionTimeLimitMillis, this.scheduleType, this.quartzSchedule, this.scheduleTimeZone, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.group, this.readWriteGroups, this.readOnlyGroups, this.bounceAfterScale, this.skipHealthchecks, this.emailConfigurationOverrides, Optional.absent(), this.hideEvenNumberAcrossRacksHint, this.taskLogErrorRegex, this.taskLogErrorRegexCaseSensitive, this.taskPriorityLevel, this.maxTasksPerOffer, this.allowBounceToSameHost, this.requiredRole);
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public SingularityRequestBuilder setSkipHealthchecks(Optional<Boolean> skipHealthchecks) {
        this.skipHealthchecks = skipHealthchecks;
        return this;
    }

    public Optional<Boolean> getLoadBalanced() {
        return this.loadBalanced;
    }

    public SingularityRequestBuilder setLoadBalanced(Optional<Boolean> loadBalanced) {
        this.loadBalanced = loadBalanced;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Optional<List<String>> getOwners() {
        return this.owners;
    }

    public SingularityRequestBuilder setOwners(Optional<List<String>> owners) {
        this.owners = owners;
        return this;
    }

    public Optional<Integer> getNumRetriesOnFailure() {
        return this.numRetriesOnFailure;
    }

    public SingularityRequestBuilder setNumRetriesOnFailure(Optional<Integer> numRetriesOnFailure) {
        this.numRetriesOnFailure = numRetriesOnFailure;
        return this;
    }

    public Optional<String> getSchedule() {
        return this.schedule;
    }

    public SingularityRequestBuilder setSchedule(Optional<String> schedule) {
        this.schedule = schedule;
        return this;
    }

    public Optional<Integer> getInstances() {
        return this.instances;
    }

    public SingularityRequestBuilder setInstances(Optional<Integer> instances) {
        this.instances = instances;
        return this;
    }

    public SingularityRequestBuilder setRequiredRole(Optional<String> requiredRole) {
        this.requiredRole = requiredRole;
        return this;
    }

    public Optional<Boolean> getRackSensitive() {
        return this.rackSensitive;
    }

    public SingularityRequestBuilder setRackSensitive(Optional<Boolean> rackSensitive) {
        this.rackSensitive = rackSensitive;
        return this;
    }

    public Optional<Long> getKillOldNonLongRunningTasksAfterMillis() {
        return this.killOldNonLongRunningTasksAfterMillis;
    }

    public SingularityRequestBuilder setKillOldNonLongRunningTasksAfterMillis(Optional<Long> killOldNonLongRunningTasksAfterMillis) {
        this.killOldNonLongRunningTasksAfterMillis = killOldNonLongRunningTasksAfterMillis;
        return this;
    }

    public Optional<Long> getTaskExecutionTimeLimitMillis() {
        return this.taskExecutionTimeLimitMillis;
    }

    public SingularityRequestBuilder setTaskExecutionTimeLimitMillis(Optional<Long> taskExecutionTimeLimitMillis) {
        this.taskExecutionTimeLimitMillis = taskExecutionTimeLimitMillis;
        return this;
    }

    public Optional<ScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    public SingularityRequestBuilder setScheduleType(Optional<ScheduleType> scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    public Optional<String> getQuartzSchedule() {
        return this.quartzSchedule;
    }

    public SingularityRequestBuilder setQuartzSchedule(Optional<String> quartzSchedule) {
        this.quartzSchedule = quartzSchedule;
        return this;
    }

    public Optional<String> getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    public SingularityRequestBuilder setScheduleTimeZone(Optional<String> scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
        return this;
    }

    public Optional<List<String>> getRackAffinity() {
        return this.rackAffinity;
    }

    public SingularityRequestBuilder setRackAffinity(Optional<List<String>> rackAffinity) {
        this.rackAffinity = rackAffinity;
        return this;
    }

    public Optional<SlavePlacement> getSlavePlacement() {
        return this.slavePlacement;
    }

    public SingularityRequestBuilder setSlavePlacement(Optional<SlavePlacement> slavePlacement) {
        this.slavePlacement = slavePlacement;
        return this;
    }

    public Optional<Long> getScheduledExpectedRuntimeMillis() {
        return this.scheduledExpectedRuntimeMillis;
    }

    public SingularityRequestBuilder setScheduledExpectedRuntimeMillis(Optional<Long> scheduledExpectedRuntimeMillis) {
        this.scheduledExpectedRuntimeMillis = scheduledExpectedRuntimeMillis;
        return this;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public Optional<Long> getWaitAtLeastMillisAfterTaskFinishesForReschedule() {
        return this.waitAtLeastMillisAfterTaskFinishesForReschedule;
    }

    public SingularityRequestBuilder setWaitAtLeastMillisAfterTaskFinishesForReschedule(Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule) {
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = waitAtLeastMillisAfterTaskFinishesForReschedule;
        return this;
    }

    public Optional<String> getGroup() {
        return this.group;
    }

    public SingularityRequestBuilder setGroup(Optional<String> group) {
        this.group = group;
        return this;
    }

    public Optional<Set<String>> getReadWriteGroups() {
        return this.readWriteGroups;
    }

    public SingularityRequestBuilder setReadWriteGroups(Optional<Set<String>> readWriteGroups) {
        this.readWriteGroups = readWriteGroups;
        return this;
    }

    public SingularityRequestBuilder setRequiredSlaveAttributes(Optional<Map<String, String>> requiredSlaveAttributes) {
        this.requiredSlaveAttributes = requiredSlaveAttributes;
        return this;
    }

    public SingularityRequestBuilder setAllowedSlaveAttributes(Optional<Map<String, String>> allowedSlaveAttributes) {
        this.allowedSlaveAttributes = allowedSlaveAttributes;
        return this;
    }

    public Optional<Set<String>> getReadOnlyGroups() {
        return this.readOnlyGroups;
    }

    public SingularityRequestBuilder setReadOnlyGroups(Optional<Set<String>> readOnlyGroups) {
        this.readOnlyGroups = readOnlyGroups;
        return this;
    }

    public Optional<Boolean> getBounceAfterScale() {
        return this.bounceAfterScale;
    }

    public SingularityRequestBuilder setBounceAfterScale(Optional<Boolean> bounceAfterScale) {
        this.bounceAfterScale = bounceAfterScale;
        return this;
    }

    public Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> getEmailConfigurationOverrides() {
        return this.emailConfigurationOverrides;
    }

    public SingularityRequestBuilder setEmailConfigurationOverrides(Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides) {
        this.emailConfigurationOverrides = emailConfigurationOverrides;
        return this;
    }

    public Optional<Boolean> getHideEvenNumberAcrossRacksHint() {
        return this.hideEvenNumberAcrossRacksHint;
    }

    public SingularityRequestBuilder setHideEvenNumberAcrossRacksHint(Optional<Boolean> hideEvenNumberAcrossRacksHint) {
        this.hideEvenNumberAcrossRacksHint = hideEvenNumberAcrossRacksHint;
        return this;
    }

    public Optional<String> getTaskLogErrorRegex() {
        return this.taskLogErrorRegex;
    }

    public SingularityRequestBuilder setTaskLogErrorRegex(Optional<String> taskLogErrorRegex) {
        this.taskLogErrorRegex = taskLogErrorRegex;
        return this;
    }

    public Optional<Boolean> getTaskLogErrorRegexCaseSensitive() {
        return this.taskLogErrorRegexCaseSensitive;
    }

    public SingularityRequestBuilder setTaskLogErrorRegexCaseSensitive(Optional<Boolean> taskLogErrorRegexCaseSensitive) {
        this.taskLogErrorRegexCaseSensitive = taskLogErrorRegexCaseSensitive;
        return this;
    }

    public Optional<Double> getTaskPriorityLevel() {
        return this.taskPriorityLevel;
    }

    public SingularityRequestBuilder setTaskPriorityLevel(Optional<Double> taskPriorityLevel) {
        this.taskPriorityLevel = taskPriorityLevel;
        return this;
    }

    public Optional<Integer> getMaxTasksPerOffer() {
        return this.maxTasksPerOffer;
    }

    public SingularityRequestBuilder setMaxTasksPerOffer(Optional<Integer> maxTasksPerOffer) {
        this.maxTasksPerOffer = maxTasksPerOffer;
        return this;
    }

    public Optional<Boolean> getAllowBounceToSameHost() {
        return this.allowBounceToSameHost;
    }

    public SingularityRequestBuilder setAllowBounceToSameHost(Optional<Boolean> allowBounceToSameHost) {
        this.allowBounceToSameHost = allowBounceToSameHost;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequestBuilder that = (SingularityRequestBuilder)o;
        return Objects.equals(this.id, that.id) && this.requestType == that.requestType && Objects.equals(this.owners, that.owners) && Objects.equals(this.numRetriesOnFailure, that.numRetriesOnFailure) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.quartzSchedule, that.quartzSchedule) && Objects.equals(this.scheduleTimeZone, that.scheduleTimeZone) && Objects.equals(this.scheduleType, that.scheduleType) && Objects.equals(this.killOldNonLongRunningTasksAfterMillis, that.killOldNonLongRunningTasksAfterMillis) && Objects.equals(this.taskExecutionTimeLimitMillis, that.taskExecutionTimeLimitMillis) && Objects.equals(this.scheduledExpectedRuntimeMillis, that.scheduledExpectedRuntimeMillis) && Objects.equals(this.waitAtLeastMillisAfterTaskFinishesForReschedule, that.waitAtLeastMillisAfterTaskFinishesForReschedule) && Objects.equals(this.instances, that.instances) && Objects.equals(this.skipHealthchecks, that.skipHealthchecks) && Objects.equals(this.rackSensitive, that.rackSensitive) && Objects.equals(this.rackAffinity, that.rackAffinity) && Objects.equals(this.slavePlacement, that.slavePlacement) && Objects.equals(this.requiredSlaveAttributes, that.requiredSlaveAttributes) && Objects.equals(this.allowedSlaveAttributes, that.allowedSlaveAttributes) && Objects.equals(this.loadBalanced, that.loadBalanced) && Objects.equals(this.requiredRole, that.requiredRole) && Objects.equals(this.group, that.group) && Objects.equals(this.readWriteGroups, that.readWriteGroups) && Objects.equals(this.readOnlyGroups, that.readOnlyGroups) && Objects.equals(this.bounceAfterScale, that.bounceAfterScale) && Objects.equals(this.emailConfigurationOverrides, that.emailConfigurationOverrides) && Objects.equals(this.hideEvenNumberAcrossRacksHint, that.hideEvenNumberAcrossRacksHint) && Objects.equals(this.taskLogErrorRegex, that.taskLogErrorRegex) && Objects.equals(this.taskLogErrorRegexCaseSensitive, that.taskLogErrorRegexCaseSensitive) && Objects.equals(this.taskPriorityLevel, that.taskPriorityLevel) && Objects.equals(this.maxTasksPerOffer, that.maxTasksPerOffer) && Objects.equals(this.allowBounceToSameHost, that.allowBounceToSameHost);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.quartzSchedule, this.scheduleTimeZone, this.scheduleType, this.killOldNonLongRunningTasksAfterMillis, this.taskExecutionTimeLimitMillis, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.instances, this.skipHealthchecks, this.rackSensitive, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.loadBalanced, this.requiredRole, this.group, this.readWriteGroups, this.readOnlyGroups, this.bounceAfterScale, this.emailConfigurationOverrides, this.hideEvenNumberAcrossRacksHint, this.taskLogErrorRegex, this.taskLogErrorRegexCaseSensitive, this.taskPriorityLevel, this.maxTasksPerOffer, this.allowBounceToSameHost});
    }

    public String toString() {
        return "SingularityRequestBuilder{id='" + this.id + '\'' + ", requestType=" + (Object)((Object)this.requestType) + ", owners=" + this.owners + ", numRetriesOnFailure=" + this.numRetriesOnFailure + ", schedule=" + this.schedule + ", quartzSchedule=" + this.quartzSchedule + ", scheduleTimeZone=" + this.scheduleTimeZone + ", scheduleType=" + this.scheduleType + ", killOldNonLongRunningTasksAfterMillis=" + this.killOldNonLongRunningTasksAfterMillis + ", taskExecutionTimeLimitMillis=" + this.taskExecutionTimeLimitMillis + ", scheduledExpectedRuntimeMillis=" + this.scheduledExpectedRuntimeMillis + ", waitAtLeastMillisAfterTaskFinishesForReschedule=" + this.waitAtLeastMillisAfterTaskFinishesForReschedule + ", instances=" + this.instances + ", skipHealthchecks=" + this.skipHealthchecks + ", rackSensitive=" + this.rackSensitive + ", rackAffinity=" + this.rackAffinity + ", slavePlacement=" + this.slavePlacement + ", requiredSlaveAttributes=" + this.requiredSlaveAttributes + ", allowedSlaveAttributes=" + this.allowedSlaveAttributes + ", loadBalanced=" + this.loadBalanced + ", requiredRole=" + this.requiredRole + ", group=" + this.group + ", readWriteGroups=" + this.readWriteGroups + ", readOnlyGroups=" + this.readOnlyGroups + ", bounceAfterScale=" + this.bounceAfterScale + ", emailConfigurationOverrides=" + this.emailConfigurationOverrides + ", hideEvenNumberAcrossRacksHint=" + this.hideEvenNumberAcrossRacksHint + ", taskLogErrorRegex=" + this.taskLogErrorRegex + ", taskLogErrorRegexCaseSensitive=" + this.taskLogErrorRegexCaseSensitive + ", taskPriorityLevel=" + this.taskPriorityLevel + ", maxTasksPerOffer=" + this.maxTasksPerOffer + ", allowBounceToSameHost=" + this.allowBounceToSameHost + '}';
    }
}

