/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.InvalidSingularityTaskIdException;
import com.hubspot.singularity.SingularityId;
import com.hubspot.singularity.SingularityPendingRequest;
import javax.annotation.Nonnull;

public class SingularityPendingTaskId
extends SingularityId
implements Comparable<SingularityPendingTaskId> {
    private final String requestId;
    private final String deployId;
    private final long nextRunAt;
    private final long createdAt;
    private final int instanceNo;
    private final SingularityPendingRequest.PendingType pendingType;

    public static Predicate<SingularityPendingTaskId> matchingRequestId(final String requestId) {
        return new Predicate<SingularityPendingTaskId>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTaskId input) {
                return input.getRequestId().equals(requestId);
            }
        };
    }

    public static Predicate<SingularityPendingTaskId> matchingDeployId(final String deployId) {
        return new Predicate<SingularityPendingTaskId>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTaskId input) {
                return input.getDeployId().equals(deployId);
            }
        };
    }

    @JsonCreator
    public SingularityPendingTaskId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="nextRunAt") long nextRunAt, @JsonProperty(value="instanceNo") int instanceNo, @JsonProperty(value="pendingType") SingularityPendingRequest.PendingType pendingType, @JsonProperty(value="createdAt") long createdAt) {
        super(String.format("%s-%s-%s-%s-%s-%s", new Object[]{requestId, deployId, nextRunAt, instanceNo, pendingType, createdAt}));
        this.requestId = requestId;
        this.deployId = deployId;
        this.nextRunAt = nextRunAt;
        this.createdAt = createdAt;
        this.instanceNo = instanceNo;
        this.pendingType = pendingType;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getNextRunAt() {
        return this.nextRunAt;
    }

    public int getInstanceNo() {
        return this.instanceNo;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public SingularityPendingRequest.PendingType getPendingType() {
        return this.pendingType;
    }

    public static SingularityPendingTaskId valueOf(String string) {
        String[] splits = null;
        try {
            splits = JavaUtils.reverseSplit(string, 6, "-");
        }
        catch (IllegalStateException ise) {
            throw new InvalidSingularityTaskIdException(String.format("PendingTaskId %s was invalid (%s)", string, ise.getMessage()));
        }
        try {
            String requestId = splits[0];
            String deployId = splits[1];
            long nextRunAt = Long.parseLong(splits[2]);
            int instanceNo = Integer.parseInt(splits[3]);
            SingularityPendingRequest.PendingType pendingType = SingularityPendingRequest.PendingType.valueOf(splits[4]);
            long createdAt = Long.parseLong(splits[5]);
            return new SingularityPendingTaskId(requestId, deployId, nextRunAt, instanceNo, pendingType, createdAt);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSingularityTaskIdException(String.format("PendingTaskId %s had an invalid parameter (%s)", string, e.getMessage()));
        }
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int compareTo(SingularityPendingTaskId o) {
        return ComparisonChain.start().compare(this.getNextRunAt(), o.getNextRunAt()).compare((Comparable<?>)((Object)this.getRequestId()), (Comparable<?>)((Object)o.getRequestId())).compare((Comparable<?>)((Object)this.getDeployId()), (Comparable<?>)((Object)o.getDeployId())).compare(this.getInstanceNo(), o.getInstanceNo()).compare(this.getCreatedAt(), o.getCreatedAt()).compare((Comparable<?>)((Object)this.getPendingType()), (Comparable<?>)((Object)o.getPendingType())).result();
    }
}

