/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.hubspot.mesos.Resources;
import com.hubspot.singularity.SingularityPendingTaskId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SingularityPendingTask {
    private final SingularityPendingTaskId pendingTaskId;
    private final Optional<List<String>> cmdLineArgsList;
    private final Optional<String> user;
    private final Optional<String> runId;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<String> message;
    private final Optional<Resources> resources;
    private final Optional<String> actionId;

    public static Predicate<SingularityPendingTask> matchingRequest(final String requestId) {
        return new Predicate<SingularityPendingTask>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTask input) {
                return input.getPendingTaskId().getRequestId().equals(requestId);
            }
        };
    }

    public static Predicate<SingularityPendingTask> matchingDeploy(final String deployId) {
        return new Predicate<SingularityPendingTask>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTask input) {
                return input.getPendingTaskId().getDeployId().equals(deployId);
            }
        };
    }

    @JsonCreator
    public SingularityPendingTask(@JsonProperty(value="pendingTaskId") SingularityPendingTaskId pendingTaskId, @JsonProperty(value="cmdLineArgsList") Optional<List<String>> cmdLineArgsList, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="actionId") Optional<String> actionId) {
        this.pendingTaskId = pendingTaskId;
        this.user = user;
        this.message = message;
        this.cmdLineArgsList = cmdLineArgsList;
        this.runId = runId;
        this.skipHealthchecks = skipHealthchecks;
        this.resources = resources;
        this.actionId = actionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityPendingTask that = (SingularityPendingTask)o;
        return Objects.equals(this.pendingTaskId, that.pendingTaskId);
    }

    public int hashCode() {
        return Objects.hash(this.pendingTaskId);
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public SingularityPendingTaskId getPendingTaskId() {
        return this.pendingTaskId;
    }

    public Optional<List<String>> getCmdLineArgsList() {
        return this.cmdLineArgsList;
    }

    public Optional<String> getRunId() {
        return this.runId;
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<Resources> getResources() {
        return this.resources;
    }

    public Optional<String> getActionId() {
        return this.actionId;
    }

    public String toString() {
        return "SingularityPendingTask{pendingTaskId=" + this.pendingTaskId + ", cmdLineArgsList=" + this.cmdLineArgsList + ", user=" + this.user + ", runId=" + this.runId + ", skipHealthchecks=" + this.skipHealthchecks + ", message=" + this.message + ", resources=" + this.resources + ", actionId=" + this.actionId + '}';
    }
}

