/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.hubspot.singularity.SingularityDisasterDataPoint;

public class SingularityMailDisasterDataPoint {
    private final String time;
    private final int numActiveTasks;
    private final int numPendingTasks;
    private final int numLateTasks;
    private final long avgTaskLagMillis;
    private final int numLostTasks;
    private final int numLostSlaves;

    @JsonCreator
    public SingularityMailDisasterDataPoint(String humanizedTimestamp, SingularityDisasterDataPoint dataPoint) {
        this.time = humanizedTimestamp;
        this.numActiveTasks = dataPoint.getNumActiveTasks();
        this.numPendingTasks = dataPoint.getNumPendingTasks();
        this.numLateTasks = dataPoint.getNumLateTasks();
        this.avgTaskLagMillis = dataPoint.getAvgTaskLagMillis();
        this.numLostTasks = dataPoint.getNumLostTasks();
        this.numLostSlaves = dataPoint.getNumLostSlaves();
    }

    public String getTime() {
        return this.time;
    }

    public int getNumActiveTasks() {
        return this.numActiveTasks;
    }

    public int getNumPendingTasks() {
        return this.numPendingTasks;
    }

    public int getNumLateTasks() {
        return this.numLateTasks;
    }

    public long getAvgTaskLagMillis() {
        return this.avgTaskLagMillis;
    }

    public int getNumLostTasks() {
        return this.numLostTasks;
    }

    public int getNumLostSlaves() {
        return this.numLostSlaves;
    }
}

