/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityDisaster;
import com.hubspot.singularity.SingularityDisasterDataPoint;
import java.util.List;
import java.util.Objects;

public class SingularityDisastersData {
    private final List<SingularityDisasterDataPoint> stats;
    private final List<SingularityDisaster> disasters;
    private final boolean automatedActionDisabled;

    @JsonCreator
    public SingularityDisastersData(@JsonProperty(value="stats") List<SingularityDisasterDataPoint> stats, @JsonProperty(value="disasterStates") List<SingularityDisaster> disasters, @JsonProperty(value="automatedActionDisabled") boolean automatedActionDisabled) {
        this.stats = stats;
        this.disasters = disasters;
        this.automatedActionDisabled = automatedActionDisabled;
    }

    public List<SingularityDisasterDataPoint> getStats() {
        return this.stats;
    }

    public List<SingularityDisaster> getDisasters() {
        return this.disasters;
    }

    public boolean isAutomatedActionsDisabled() {
        return this.automatedActionDisabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDisastersData that = (SingularityDisastersData)o;
        return this.automatedActionDisabled == that.automatedActionDisabled && Objects.equals(this.stats, that.stats) && Objects.equals(this.disasters, that.disasters);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.disasters, this.automatedActionDisabled);
    }

    public String toString() {
        return "SingularityDisastersData{stats=" + this.stats + ", disasters=" + this.disasters + ", automatedActionDisabled=" + this.automatedActionDisabled + '}';
    }
}

