/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityDeployStatisticsBuilder;

public class SingularityDeployStatistics {
    private final String requestId;
    private final String deployId;
    private final int numTasks;
    private final int numSuccess;
    private final int numFailures;
    private final int numSequentialRetries;
    private final ListMultimap<Integer, Long> instanceSequentialFailureTimestamps;
    private final Optional<Long> lastFinishAt;
    private final Optional<ExtendedTaskState> lastTaskState;
    private final Optional<Long> averageRuntimeMillis;

    @JsonCreator
    public SingularityDeployStatistics(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="numSuccess") int numSuccess, @JsonProperty(value="numFailures") int numFailures, @JsonProperty(value="numSequentialRetries") int numSequentialRetries, @JsonProperty(value="lastFinishAt") Optional<Long> lastFinishAt, @JsonProperty(value="lastTaskState") Optional<ExtendedTaskState> lastTaskState, @JsonProperty(value="instanceSequentialFailureTimestamps") ListMultimap<Integer, Long> instanceSequentialFailureTimestamps, @JsonProperty(value="numTasks") int numTasks, @JsonProperty(value="averageRuntimeMillis") Optional<Long> averageRuntimeMillis) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.numSuccess = numSuccess;
        this.numFailures = numFailures;
        this.lastFinishAt = lastFinishAt;
        this.lastTaskState = lastTaskState;
        this.numSequentialRetries = numSequentialRetries;
        this.numTasks = numTasks;
        this.averageRuntimeMillis = averageRuntimeMillis;
        this.instanceSequentialFailureTimestamps = instanceSequentialFailureTimestamps == null ? ImmutableListMultimap.of() : ImmutableListMultimap.copyOf(instanceSequentialFailureTimestamps);
    }

    public SingularityDeployStatisticsBuilder toBuilder() {
        return new SingularityDeployStatisticsBuilder(this.requestId, this.deployId).setLastFinishAt(this.lastFinishAt).setLastTaskState(this.lastTaskState).setNumSequentialRetries(this.numSequentialRetries).setNumFailures(this.numFailures).setNumSuccess(this.numSuccess).setNumTasks(this.numTasks).setAverageRuntimeMillis(this.averageRuntimeMillis).setInstanceSequentialFailureTimestamps(ArrayListMultimap.create(this.instanceSequentialFailureTimestamps));
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public Optional<Long> getAverageRuntimeMillis() {
        return this.averageRuntimeMillis;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public int getNumSuccess() {
        return this.numSuccess;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public Optional<Long> getLastFinishAt() {
        return this.lastFinishAt;
    }

    public Optional<ExtendedTaskState> getLastTaskState() {
        return this.lastTaskState;
    }

    public int getNumSequentialRetries() {
        return this.numSequentialRetries;
    }

    public ListMultimap<Integer, Long> getInstanceSequentialFailureTimestamps() {
        return this.instanceSequentialFailureTimestamps;
    }

    public String toString() {
        return "SingularityDeployStatistics{requestId='" + this.requestId + '\'' + ", deployId='" + this.deployId + '\'' + ", numTasks=" + this.numTasks + ", numSuccess=" + this.numSuccess + ", numFailures=" + this.numFailures + ", numSequentialRetries=" + this.numSequentialRetries + ", instanceSequentialFailureTimestamps=" + this.instanceSequentialFailureTimestamps + ", lastFinishAt=" + this.lastFinishAt + ", lastTaskState=" + this.lastTaskState + ", averageRuntimeMillis=" + this.averageRuntimeMillis + '}';
    }
}

