/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeploy;
import com.hubspot.singularity.SingularityDeployMarker;
import com.hubspot.singularity.SingularityDeployResult;
import com.hubspot.singularity.SingularityDeployStatistics;
import com.hubspot.singularity.SingularityHistoryItem;
import java.util.Objects;

public class SingularityDeployHistory
implements Comparable<SingularityDeployHistory>,
SingularityHistoryItem {
    private final Optional<SingularityDeployResult> deployResult;
    private final SingularityDeployMarker deployMarker;
    private final Optional<SingularityDeploy> deploy;
    private final Optional<SingularityDeployStatistics> deployStatistics;

    @JsonCreator
    public SingularityDeployHistory(@JsonProperty(value="deployResult") Optional<SingularityDeployResult> deployResult, @JsonProperty(value="deployMarker") SingularityDeployMarker deployMarker, @JsonProperty(value="deploy") Optional<SingularityDeploy> deploy, @JsonProperty(value="deployStatistics") Optional<SingularityDeployStatistics> deployStatistics) {
        this.deployResult = deployResult;
        this.deployMarker = deployMarker;
        this.deploy = deploy;
        this.deployStatistics = deployStatistics;
    }

    @Override
    public int compareTo(SingularityDeployHistory o) {
        return o.getDeployMarker().compareTo(this.getDeployMarker());
    }

    public Optional<SingularityDeployResult> getDeployResult() {
        return this.deployResult;
    }

    public SingularityDeployMarker getDeployMarker() {
        return this.deployMarker;
    }

    public Optional<SingularityDeploy> getDeploy() {
        return this.deploy;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.deployMarker.getTimestamp();
    }

    public Optional<SingularityDeployStatistics> getDeployStatistics() {
        return this.deployStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDeployHistory that = (SingularityDeployHistory)o;
        return Objects.equals(this.deployResult, that.deployResult) && Objects.equals(this.deployMarker, that.deployMarker) && Objects.equals(this.deploy, that.deploy) && Objects.equals(this.deployStatistics, that.deployStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.deployResult, this.deployMarker, this.deploy, this.deployStatistics);
    }

    public String toString() {
        return "SingularityDeployHistory{deployResult=" + this.deployResult + ", deployMarker=" + this.deployMarker + ", deploy=" + this.deploy + ", deployStatistics=" + this.deployStatistics + '}';
    }
}

