/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.deploy.HealthcheckOptions;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityContainerInfo;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.mesos.SingularityMesosTaskLabel;
import com.hubspot.singularity.HealthcheckProtocol;
import com.hubspot.singularity.JsonHelpers;
import com.hubspot.singularity.SingularityDeployBuilder;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SingularityDeploy {
    private final String requestId;
    private final String id;
    private final Optional<String> version;
    private final Optional<Long> timestamp;
    private final Optional<Map<String, String>> metadata;
    private final Optional<SingularityContainerInfo> containerInfo;
    private final Optional<String> customExecutorCmd;
    private final Optional<String> customExecutorId;
    private final Optional<String> customExecutorSource;
    private final Optional<Resources> customExecutorResources;
    private final Optional<Resources> resources;
    private final Optional<String> command;
    private final Optional<List<String>> arguments;
    private final Optional<Map<String, String>> env;
    private final Optional<List<SingularityMesosArtifact>> uris;
    private final Optional<ExecutorData> executorData;
    private final Optional<Map<String, String>> labels;
    private final Optional<List<SingularityMesosTaskLabel>> mesosLabels;
    private final Optional<Map<Integer, Map<String, String>>> taskLabels;
    private final Optional<Map<Integer, List<SingularityMesosTaskLabel>>> mesosTaskLabels;
    private final Optional<Map<Integer, Map<String, String>>> taskEnv;
    @Deprecated
    private final Optional<String> healthcheckUri;
    @Deprecated
    private final Optional<Long> healthcheckIntervalSeconds;
    @Deprecated
    private final Optional<Long> healthcheckTimeoutSeconds;
    @Deprecated
    private final Optional<Integer> healthcheckPortIndex;
    @Deprecated
    private final Optional<HealthcheckProtocol> healthcheckProtocol;
    @Deprecated
    private final Optional<Integer> healthcheckMaxRetries;
    @Deprecated
    private final Optional<Long> healthcheckMaxTotalTimeoutSeconds;
    private final Optional<HealthcheckOptions> healthcheck;
    private final Optional<Boolean> skipHealthchecksOnDeploy;
    private final Optional<Long> deployHealthTimeoutSeconds;
    private final Optional<Long> considerHealthyAfterRunningForSeconds;
    private final Optional<String> serviceBasePath;
    private final Optional<Set<String>> loadBalancerGroups;
    private final Optional<Integer> loadBalancerPortIndex;
    private final Optional<Map<String, Object>> loadBalancerOptions;
    private final Optional<Set<String>> loadBalancerDomains;
    private final Optional<List<String>> loadBalancerAdditionalRoutes;
    private final Optional<String> loadBalancerTemplate;
    private final Optional<String> loadBalancerServiceIdOverride;
    private final Optional<String> loadBalancerUpstreamGroup;
    private final Optional<Integer> deployInstanceCountPerStep;
    private final Optional<Integer> deployStepWaitTimeMs;
    private final Optional<Boolean> autoAdvanceDeploySteps;
    private final Optional<Integer> maxTaskRetries;
    private final Optional<Boolean> shell;
    private final Optional<String> user;

    public static SingularityDeployBuilder newBuilder(String requestId, String id) {
        return new SingularityDeployBuilder(requestId, id);
    }

    @JsonCreator
    public SingularityDeploy(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="id") String id, @JsonProperty(value="command") Optional<String> command, @JsonProperty(value="arguments") Optional<List<String>> arguments, @JsonProperty(value="containerInfo") Optional<SingularityContainerInfo> containerInfo, @JsonProperty(value="customExecutorCmd") Optional<String> customExecutorCmd, @JsonProperty(value="customExecutorId") Optional<String> customExecutorId, @JsonProperty(value="customExecutorSource") Optional<String> customExecutorSource, @JsonProperty(value="customExecutorResources") Optional<Resources> customExecutorResources, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="env") Optional<Map<String, String>> env, @JsonProperty(value="taskEnv") Optional<Map<Integer, Map<String, String>>> taskEnv, @JsonProperty(value="uris") Optional<List<SingularityMesosArtifact>> uris, @JsonProperty(value="metadata") Optional<Map<String, String>> metadata, @JsonProperty(value="executorData") Optional<ExecutorData> executorData, @JsonProperty(value="version") Optional<String> version, @JsonProperty(value="timestamp") Optional<Long> timestamp, @JsonProperty(value="labels") Optional<Map<String, String>> labels, @JsonProperty(value="mesosLabels") Optional<List<SingularityMesosTaskLabel>> mesosLabels, @JsonProperty(value="taskLabels") Optional<Map<Integer, Map<String, String>>> taskLabels, @JsonProperty(value="mesosTaskLabels") Optional<Map<Integer, List<SingularityMesosTaskLabel>>> mesosTaskLabels, @JsonProperty(value="deployHealthTimeoutSeconds") Optional<Long> deployHealthTimeoutSeconds, @JsonProperty(value="healthcheckUri") Optional<String> healthcheckUri, @JsonProperty(value="healthcheckIntervalSeconds") Optional<Long> healthcheckIntervalSeconds, @JsonProperty(value="healthcheckTimeoutSeconds") Optional<Long> healthcheckTimeoutSeconds, @JsonProperty(value="healthcheckPortIndex") Optional<Integer> healthcheckPortIndex, @JsonProperty(value="healthcheckMaxRetries") Optional<Integer> healthcheckMaxRetries, @JsonProperty(value="healthcheckMaxTotalTimeoutSeconds") Optional<Long> healthcheckMaxTotalTimeoutSeconds, @JsonProperty(value="healthcheck") Optional<HealthcheckOptions> healthcheck, @JsonProperty(value="serviceBasePath") Optional<String> serviceBasePath, @JsonProperty(value="loadBalancerGroups") Optional<Set<String>> loadBalancerGroups, @JsonProperty(value="loadBalancerPortIndex") Optional<Integer> loadBalancerPortIndex, @JsonProperty(value="considerHealthyAfterRunningForSeconds") Optional<Long> considerHealthyAfterRunningForSeconds, @JsonProperty(value="loadBalancerOptions") Optional<Map<String, Object>> loadBalancerOptions, @JsonProperty(value="loadBalancerDomains") Optional<Set<String>> loadBalancerDomains, @JsonProperty(value="loadBalancerAdditionalRoutes") Optional<List<String>> loadBalancerAdditionalRoutes, @JsonProperty(value="loadBalancerTemplate") Optional<String> loadBalancerTemplate, @JsonProperty(value="loadBalancerServiceIdOverride") Optional<String> loadBalancerServiceIdOverride, @JsonProperty(value="loadBalancerUpstreamGroup") Optional<String> loadBalancerUpstreamGroup, @JsonProperty(value="skipHealthchecksOnDeploy") Optional<Boolean> skipHealthchecksOnDeploy, @JsonProperty(value="healthCheckProtocol") Optional<HealthcheckProtocol> healthcheckProtocol, @JsonProperty(value="deployInstanceCountPerStep") Optional<Integer> deployInstanceCountPerStep, @JsonProperty(value="deployStepWaitTimeMs") Optional<Integer> deployStepWaitTimeMs, @JsonProperty(value="autoAdvanceDeploySteps") Optional<Boolean> autoAdvanceDeploySteps, @JsonProperty(value="maxTaskRetries") Optional<Integer> maxTaskRetries, @JsonProperty(value="shell") Optional<Boolean> shell, @JsonProperty(value="user") Optional<String> user) {
        this.requestId = requestId;
        this.command = command;
        this.arguments = arguments;
        this.resources = resources;
        this.containerInfo = containerInfo;
        this.customExecutorCmd = customExecutorCmd;
        this.customExecutorId = customExecutorId;
        this.customExecutorSource = customExecutorSource;
        this.customExecutorResources = customExecutorResources;
        this.metadata = metadata;
        this.version = version;
        this.id = id;
        this.timestamp = timestamp;
        this.env = env;
        this.taskEnv = taskEnv;
        this.uris = uris;
        this.executorData = executorData;
        this.labels = labels;
        this.mesosLabels = mesosLabels.or(labels.isPresent() ? Optional.of(SingularityMesosTaskLabel.labelsFromMap(labels.get())) : Optional.absent());
        this.taskLabels = taskLabels;
        this.mesosTaskLabels = mesosTaskLabels.or(taskLabels.isPresent() ? Optional.of(SingularityDeploy.parseMesosTaskLabelsFromMap(taskLabels.get())) : Optional.absent());
        this.healthcheckUri = healthcheckUri;
        this.healthcheckIntervalSeconds = healthcheckIntervalSeconds;
        this.healthcheckTimeoutSeconds = healthcheckTimeoutSeconds;
        this.healthcheckPortIndex = healthcheckPortIndex;
        this.skipHealthchecksOnDeploy = skipHealthchecksOnDeploy;
        this.healthcheckProtocol = healthcheckProtocol;
        this.healthcheckMaxRetries = healthcheckMaxRetries;
        this.healthcheckMaxTotalTimeoutSeconds = healthcheckMaxTotalTimeoutSeconds;
        this.healthcheck = healthcheckUri.isPresent() && !healthcheck.isPresent() ? Optional.of(new HealthcheckOptions(healthcheckUri.get(), healthcheckPortIndex, Optional.absent(), healthcheckProtocol, Optional.absent(), Optional.absent(), Optional.absent(), healthcheckIntervalSeconds.isPresent() ? Optional.of(healthcheckIntervalSeconds.get().intValue()) : Optional.absent(), healthcheckTimeoutSeconds.isPresent() ? Optional.of(healthcheckTimeoutSeconds.get().intValue()) : Optional.absent(), healthcheckMaxRetries, Optional.absent())) : healthcheck;
        this.considerHealthyAfterRunningForSeconds = considerHealthyAfterRunningForSeconds;
        this.deployHealthTimeoutSeconds = deployHealthTimeoutSeconds;
        this.serviceBasePath = serviceBasePath;
        this.loadBalancerGroups = loadBalancerGroups;
        this.loadBalancerPortIndex = loadBalancerPortIndex;
        this.loadBalancerOptions = loadBalancerOptions;
        this.loadBalancerDomains = loadBalancerDomains;
        this.loadBalancerAdditionalRoutes = loadBalancerAdditionalRoutes;
        this.loadBalancerTemplate = loadBalancerTemplate;
        this.loadBalancerServiceIdOverride = loadBalancerServiceIdOverride;
        this.loadBalancerUpstreamGroup = loadBalancerUpstreamGroup;
        this.deployInstanceCountPerStep = deployInstanceCountPerStep;
        this.deployStepWaitTimeMs = deployStepWaitTimeMs;
        this.autoAdvanceDeploySteps = autoAdvanceDeploySteps;
        this.maxTaskRetries = maxTaskRetries;
        this.shell = shell;
        this.user = user;
    }

    private static Map<Integer, List<SingularityMesosTaskLabel>> parseMesosTaskLabelsFromMap(Map<Integer, Map<String, String>> taskLabels) {
        HashMap<Integer, List<SingularityMesosTaskLabel>> mesosTaskLabels = new HashMap<Integer, List<SingularityMesosTaskLabel>>();
        for (Map.Entry<Integer, Map<String, String>> entry : taskLabels.entrySet()) {
            mesosTaskLabels.put(entry.getKey(), SingularityMesosTaskLabel.labelsFromMap(entry.getValue()));
        }
        return mesosTaskLabels;
    }

    public SingularityDeployBuilder toBuilder() {
        return new SingularityDeployBuilder(this.requestId, this.id).setCommand(this.command).setArguments(JsonHelpers.copyOfList(this.arguments)).setResources(this.resources).setContainerInfo(this.containerInfo).setCustomExecutorCmd(this.customExecutorCmd).setCustomExecutorId(this.customExecutorId).setCustomExecutorSource(this.customExecutorSource).setCustomExecutorResources(this.customExecutorResources).setHealthcheckUri(this.healthcheckUri).setHealthcheckIntervalSeconds(this.healthcheckIntervalSeconds).setHealthcheckTimeoutSeconds(this.healthcheckTimeoutSeconds).setHealthcheckPortIndex(this.healthcheckPortIndex).setSkipHealthchecksOnDeploy(this.skipHealthchecksOnDeploy).setHealthcheckProtocol(this.healthcheckProtocol).setHealthcheckMaxRetries(this.healthcheckMaxRetries).setHealthcheckMaxTotalTimeoutSeconds(this.healthcheckMaxTotalTimeoutSeconds).setHealthcheck(this.healthcheck).setConsiderHealthyAfterRunningForSeconds(this.considerHealthyAfterRunningForSeconds).setDeployHealthTimeoutSeconds(this.deployHealthTimeoutSeconds).setServiceBasePath(this.serviceBasePath).setLoadBalancerGroups(JsonHelpers.copyOfSet(this.loadBalancerGroups)).setLoadBalancerPortIndex(this.loadBalancerPortIndex).setLoadBalancerOptions(JsonHelpers.copyOfMap(this.loadBalancerOptions)).setLoadBalancerDomains(JsonHelpers.copyOfSet(this.loadBalancerDomains)).setLoadBalancerAdditionalRoutes(JsonHelpers.copyOfList(this.loadBalancerAdditionalRoutes)).setLoadBalancerTemplate(this.loadBalancerTemplate).setLoadBalancerUpstreamGroup(this.loadBalancerUpstreamGroup).setLoadBalancerServiceIdOverride(this.loadBalancerServiceIdOverride).setMetadata(JsonHelpers.copyOfMap(this.metadata)).setVersion(this.version).setTimestamp(this.timestamp).setEnv(JsonHelpers.copyOfMap(this.env)).setTaskEnv(this.taskEnv).setUris(this.uris).setExecutorData(this.executorData).setLabels(this.labels).setMesosLabels(this.mesosLabels).setTaskLabels(this.taskLabels).setMesosTaskLabels(this.mesosTaskLabels).setDeployInstanceCountPerStep(this.deployInstanceCountPerStep).setDeployStepWaitTimeMs(this.deployStepWaitTimeMs).setAutoAdvanceDeploySteps(this.autoAdvanceDeploySteps).setMaxTaskRetries(this.maxTaskRetries).setShell(this.shell).setUser(this.user);
    }

    @ApiModelProperty(required=false, value="Number of seconds that Singularity waits for this service to become healthy (for it to download artifacts, start running, and optionally pass healthchecks.)")
    public Optional<Long> getDeployHealthTimeoutSeconds() {
        return this.deployHealthTimeoutSeconds;
    }

    @ApiModelProperty(required=true, value="Singularity Request Id which is associated with this deploy.")
    public String getRequestId() {
        return this.requestId;
    }

    @ApiModelProperty(required=true, value="Singularity deploy id.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(required=false, value="Deploy version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @ApiModelProperty(required=false, value="Deploy timestamp.")
    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(required=false, value="Map of metadata key/value pairs associated with the deployment.")
    public Optional<Map<String, String>> getMetadata() {
        return this.metadata;
    }

    @ApiModelProperty(required=false, value="Container information for deployment into a container.", dataType="SingularityContainerInfo")
    public Optional<SingularityContainerInfo> getContainerInfo() {
        return this.containerInfo;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor", dataType="string")
    public Optional<String> getCustomExecutorCmd() {
        return this.customExecutorCmd;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor id.", dataType="string")
    public Optional<String> getCustomExecutorId() {
        return this.customExecutorId;
    }

    @ApiModelProperty(required=false, value="Custom Mesos executor source.", dataType="string")
    public Optional<String> getCustomExecutorSource() {
        return this.customExecutorSource;
    }

    @ApiModelProperty(required=false, value="Resources to allocate for custom mesos executor", dataType="com.hubspot.mesos.Resources")
    public Optional<Resources> getCustomExecutorResources() {
        return this.customExecutorResources;
    }

    @ApiModelProperty(required=false, value="Resources required for this deploy.", dataType="com.hubspot.mesos.Resources")
    public Optional<Resources> getResources() {
        return this.resources;
    }

    @ApiModelProperty(required=false, value="Command to execute for this deployment.")
    public Optional<String> getCommand() {
        return this.command;
    }

    @ApiModelProperty(required=false, value="Command arguments.")
    public Optional<List<String>> getArguments() {
        return this.arguments;
    }

    @ApiModelProperty(required=false, value="Map of environment variable definitions.")
    public Optional<Map<String, String>> getEnv() {
        return this.env;
    }

    @ApiModelProperty(required=false, value="Map of environment variable overrides for specific task instances.")
    public Optional<Map<Integer, Map<String, String>>> getTaskEnv() {
        return this.taskEnv;
    }

    @ApiModelProperty(required=false, value="List of URIs to download before executing the deploy command.")
    public Optional<List<SingularityMesosArtifact>> getUris() {
        return this.uris;
    }

    @ApiModelProperty(required=false, value="Executor specific information")
    public Optional<ExecutorData> getExecutorData() {
        return this.executorData;
    }

    @ApiModelProperty(required=false, value="Deployment Healthcheck URI, if specified will be called after TASK_RUNNING.")
    public Optional<String> getHealthcheckUri() {
        return this.healthcheckUri;
    }

    @ApiModelProperty(required=false, value="Healthcheck protocol - HTTP or HTTPS", dataType="com.hubspot.singularity.HealthcheckProtocol")
    public Optional<HealthcheckProtocol> getHealthcheckProtocol() {
        return this.healthcheckProtocol;
    }

    @ApiModelProperty(required=false, value="Time to wait after a failed healthcheck to try again in seconds.")
    public Optional<Long> getHealthcheckIntervalSeconds() {
        return this.healthcheckIntervalSeconds;
    }

    @ApiModelProperty(required=false, value="Single healthcheck HTTP timeout in seconds.")
    public Optional<Long> getHealthcheckTimeoutSeconds() {
        return this.healthcheckTimeoutSeconds;
    }

    @ApiModelProperty(required=false, value="Perform healthcheck on this dynamically allocated port (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getHealthcheckPortIndex() {
        return this.healthcheckPortIndex;
    }

    @ApiModelProperty(required=false, value="The base path for the API exposed by the deploy. Used in conjunction with the Load balancer API.")
    public Optional<String> getServiceBasePath() {
        return this.serviceBasePath;
    }

    @ApiModelProperty(required=false, value="Number of seconds that a service must be healthy to consider the deployment to be successful.")
    public Optional<Long> getConsiderHealthyAfterRunningForSeconds() {
        return this.considerHealthyAfterRunningForSeconds;
    }

    @ApiModelProperty(required=false, value="List of load balancer groups associated with this deployment.")
    public Optional<Set<String>> getLoadBalancerGroups() {
        return this.loadBalancerGroups;
    }

    @ApiModelProperty(required=false, value="Send this port to the load balancer api (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getLoadBalancerPortIndex() {
        return this.loadBalancerPortIndex;
    }

    @ApiModelProperty(required=false, value="Map (Key/Value) of options for the load balancer.")
    public Optional<Map<String, Object>> getLoadBalancerOptions() {
        return this.loadBalancerOptions;
    }

    @ApiModelProperty(required=false, value="List of domains to host this service on, for use with the load balancer api")
    public Optional<Set<String>> getLoadBalancerDomains() {
        return this.loadBalancerDomains;
    }

    @ApiModelProperty(required=false, value="Additional routes besides serviceBasePath used by this service")
    public Optional<List<String>> getLoadBalancerAdditionalRoutes() {
        return this.loadBalancerAdditionalRoutes;
    }

    @ApiModelProperty(required=false, value="Name of load balancer template to use if not using the default template")
    public Optional<String> getLoadBalancerTemplate() {
        return this.loadBalancerTemplate;
    }

    @ApiModelProperty(required=false, value="Name of load balancer Service ID to use instead of the Request ID")
    public Optional<String> getLoadBalancerServiceIdOverride() {
        return this.loadBalancerServiceIdOverride;
    }

    @ApiModelProperty(required=false, value="Group name to tag all upstreams with in load balancer")
    public Optional<String> getLoadBalancerUpstreamGroup() {
        return this.loadBalancerUpstreamGroup;
    }

    @Deprecated
    @ApiModelProperty(required=false, value="Labels for all tasks associated with this deploy")
    public Optional<Map<String, String>> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(required=false, value="Labels for all tasks associated with this deploy")
    public Optional<List<SingularityMesosTaskLabel>> getMesosLabels() {
        return this.mesosLabels;
    }

    @ApiModelProperty(required=false, value="(Deprecated) Labels for specific tasks associated with this deploy, indexed by instance number")
    public Optional<Map<Integer, Map<String, String>>> getTaskLabels() {
        return this.taskLabels;
    }

    @ApiModelProperty(required=false, value="Labels for specific tasks associated with this deploy, indexed by instance number")
    public Optional<Map<Integer, List<SingularityMesosTaskLabel>>> getMesosTaskLabels() {
        return this.mesosTaskLabels;
    }

    @ApiModelProperty(required=false, value="Allows skipping of health checks when deploying.")
    public Optional<Boolean> getSkipHealthchecksOnDeploy() {
        return this.skipHealthchecksOnDeploy;
    }

    @ApiModelProperty(required=false, value="Maximum number of times to retry an individual healthcheck before failing the deploy.")
    public Optional<Integer> getHealthcheckMaxRetries() {
        return this.healthcheckMaxRetries;
    }

    @ApiModelProperty(required=false, value="Maximum amount of time to wait before failing a deploy for healthchecks to pass.")
    public Optional<Long> getHealthcheckMaxTotalTimeoutSeconds() {
        return this.healthcheckMaxTotalTimeoutSeconds;
    }

    @ApiModelProperty(required=false, value="HTTP Healthcheck settings")
    public Optional<HealthcheckOptions> getHealthcheck() {
        return this.healthcheck;
    }

    @ApiModelProperty(required=false, value="deploy this many instances at a time")
    public Optional<Integer> getDeployInstanceCountPerStep() {
        return this.deployInstanceCountPerStep;
    }

    @ApiModelProperty(required=false, value="wait this long between deploy steps")
    public Optional<Integer> getDeployStepWaitTimeMs() {
        return this.deployStepWaitTimeMs;
    }

    @ApiModelProperty(required=false, value="automatically advance to the next target instance count after `deployStepWaitTimeMs` seconds")
    public Optional<Boolean> getAutoAdvanceDeploySteps() {
        return this.autoAdvanceDeploySteps;
    }

    @ApiModelProperty(required=false, value="allowed at most this many failed tasks to be retried before failing the deploy")
    public Optional<Integer> getMaxTaskRetries() {
        return this.maxTaskRetries;
    }

    @ApiModelProperty(required=false, value="Override the shell property on the mesos task")
    public Optional<Boolean> getShell() {
        return this.shell;
    }

    @ApiModelProperty(required=false, value="Run tasks as this user")
    public Optional<String> getUser() {
        return this.user;
    }

    public String toString() {
        return "SingularityDeploy{requestId='" + this.requestId + '\'' + ", id='" + this.id + '\'' + ", version=" + this.version + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", containerInfo=" + this.containerInfo + ", customExecutorCmd=" + this.customExecutorCmd + ", customExecutorId=" + this.customExecutorId + ", customExecutorSource=" + this.customExecutorSource + ", customExecutorResources=" + this.customExecutorResources + ", resources=" + this.resources + ", command=" + this.command + ", arguments=" + this.arguments + ", env=" + this.env + ", uris=" + this.uris + ", executorData=" + this.executorData + ", labels=" + this.labels + ", mesosLabels=" + this.mesosLabels + ", taskLabels=" + this.taskLabels + ", mesosTaskLabels=" + this.mesosTaskLabels + ", taskEnv=" + this.taskEnv + ", healthcheckUri=" + this.healthcheckUri + ", healthcheckIntervalSeconds=" + this.healthcheckIntervalSeconds + ", healthcheckTimeoutSeconds=" + this.healthcheckTimeoutSeconds + ", healthcheckPortIndex=" + this.healthcheckPortIndex + ", healthcheckProtocol=" + this.healthcheckProtocol + ", healthcheckMaxRetries=" + this.healthcheckMaxRetries + ", healthcheckMaxTotalTimeoutSeconds=" + this.healthcheckMaxTotalTimeoutSeconds + ", healthcheck=" + this.healthcheck + ", skipHealthchecksOnDeploy=" + this.skipHealthchecksOnDeploy + ", deployHealthTimeoutSeconds=" + this.deployHealthTimeoutSeconds + ", considerHealthyAfterRunningForSeconds=" + this.considerHealthyAfterRunningForSeconds + ", serviceBasePath=" + this.serviceBasePath + ", loadBalancerGroups=" + this.loadBalancerGroups + ", loadBalancerPortIndex=" + this.loadBalancerPortIndex + ", loadBalancerOptions=" + this.loadBalancerOptions + ", loadBalancerDomains=" + this.loadBalancerDomains + ", loadBalancerAdditionalRoutes=" + this.loadBalancerAdditionalRoutes + ", loadBalancerTemplate=" + this.loadBalancerTemplate + ", loadBalancerServiceIdOverride=" + this.loadBalancerServiceIdOverride + ", loadBalancerUpstreamGroup=" + this.loadBalancerUpstreamGroup + ", deployInstanceCountPerStep=" + this.deployInstanceCountPerStep + ", deployStepWaitTimeMs=" + this.deployStepWaitTimeMs + ", autoAdvanceDeploySteps=" + this.autoAdvanceDeploySteps + ", maxTaskRetries=" + this.maxTaskRetries + ", shell=" + this.shell + ", user=" + this.user + '}';
    }
}

