/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityDockerVolumeMode;
import java.util.Objects;
import org.apache.mesos.Protos;

public class SingularityVolume {
    private final String containerPath;
    private final Optional<String> hostPath;
    private final Optional<SingularityDockerVolumeMode> mode;

    @JsonCreator
    public SingularityVolume(@JsonProperty(value="containerPath") String containerPath, @JsonProperty(value="hostPath") Optional<String> hostPath, @JsonProperty(value="mode") SingularityDockerVolumeMode mode) {
        this.containerPath = containerPath;
        this.hostPath = hostPath;
        this.mode = Optional.fromNullable(mode);
    }

    @Deprecated
    public SingularityVolume(String containerPath, Optional<String> hostPath, Optional<Protos.Volume.Mode> mode) {
        this(containerPath, hostPath, SingularityVolume.convertedMode(mode));
    }

    private static SingularityDockerVolumeMode convertedMode(Optional<Protos.Volume.Mode> mode) {
        if (mode.isPresent()) {
            return SingularityDockerVolumeMode.valueOf(mode.get().toString());
        }
        return null;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public Optional<String> getHostPath() {
        return this.hostPath;
    }

    public Optional<SingularityDockerVolumeMode> getMode() {
        return this.mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityVolume that = (SingularityVolume)o;
        return Objects.equals(this.containerPath, that.containerPath) && Objects.equals(this.hostPath, that.hostPath) && Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.containerPath, this.hostPath, this.mode);
    }

    public String toString() {
        return "SingularityVolume{containerPath='" + this.containerPath + '\'' + ", hostPath=" + this.hostPath + ", mode=" + this.mode + '}';
    }
}

