/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Objects;

public class SingularityMesosArtifact {
    private final String uri;
    private final boolean cache;
    private final boolean executable;
    private final boolean extract;

    @JsonCreator
    public static SingularityMesosArtifact fromString(String uri) {
        return new SingularityMesosArtifact(uri, Optional.absent(), Optional.absent(), Optional.absent());
    }

    @JsonCreator
    public SingularityMesosArtifact(@JsonProperty(value="uri") String uri, @JsonProperty(value="cache") Optional<Boolean> cache, @JsonProperty(value="executable") Optional<Boolean> executable, @JsonProperty(value="extract") Optional<Boolean> extract) {
        this.uri = uri;
        this.cache = cache.or(false);
        this.executable = executable.or(false);
        this.extract = extract.or(true);
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isCache() {
        return this.cache;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityMesosArtifact that = (SingularityMesosArtifact)o;
        return this.cache == that.cache && this.executable == that.executable && this.extract == that.extract && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.cache, this.executable, this.extract);
    }

    public String toString() {
        return "SingularityMesosArtifact{uri='" + this.uri + '\'' + ", cache=" + this.cache + ", executable=" + this.executable + ", extract=" + this.extract + '}';
    }
}

