/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityPortMappingType;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SingularityDockerPortMapping {
    public static final String DEFAULT_PROTOCOL = "tcp";
    public static final SingularityPortMappingType DEFAULT_PORT_MAPPING_TYPE = SingularityPortMappingType.LITERAL;
    private final SingularityPortMappingType containerPortType;
    private final SingularityPortMappingType hostPortType;
    private final int containerPort;
    private final int hostPort;
    private final String protocol;

    @JsonCreator
    public SingularityDockerPortMapping(@JsonProperty(value="containerPortType") Optional<SingularityPortMappingType> containerPortType, @JsonProperty(value="containerPort") int containerPort, @JsonProperty(value="hostPortType") Optional<SingularityPortMappingType> hostPortType, @JsonProperty(value="hostPort") int hostPort, @JsonProperty(value="protocol") Optional<String> protocol) {
        this.containerPortType = containerPortType.or(DEFAULT_PORT_MAPPING_TYPE);
        this.containerPort = containerPort;
        this.hostPortType = hostPortType.or(DEFAULT_PORT_MAPPING_TYPE);
        this.hostPort = hostPort;
        this.protocol = protocol.or(DEFAULT_PROTOCOL);
    }

    @ApiModelProperty(required=false, value="Container port. Use the port number provided (LITERAL) or the dynamically allocated port at this index (FROM_OFFER)")
    public SingularityPortMappingType getContainerPortType() {
        return this.containerPortType;
    }

    @ApiModelProperty(required=true, value="Port number, or index of port from offer within the container")
    public int getContainerPort() {
        return this.containerPort;
    }

    @ApiModelProperty(required=false, value="Host port. Use the port number provided (LITERAL) or the dynamically allocated port at this index (FROM_OFFER)")
    public SingularityPortMappingType getHostPortType() {
        return this.hostPortType;
    }

    @ApiModelProperty(required=true, value="Port number, or index of port from offer on the host")
    public int getHostPort() {
        return this.hostPort;
    }

    @ApiModelProperty(required=false, value="Protocol for binding the port. Default is tcp")
    public String getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDockerPortMapping that = (SingularityDockerPortMapping)o;
        return this.containerPort == that.containerPort && this.hostPort == that.hostPort && this.containerPortType == that.containerPortType && this.hostPortType == that.hostPortType && Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerPortType, this.hostPortType, this.containerPort, this.hostPort, this.protocol});
    }

    public String toString() {
        return "SingularityDockerPortMapping{containerPortType=" + (Object)((Object)this.containerPortType) + ", hostPortType=" + (Object)((Object)this.hostPortType) + ", containerPort=" + this.containerPort + ", hostPort=" + this.hostPort + ", protocol='" + this.protocol + '\'' + '}';
    }
}

