/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityContainerType;
import com.hubspot.mesos.SingularityDockerInfo;
import com.hubspot.mesos.SingularityVolume;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

public class SingularityContainerInfo {
    private final SingularityContainerType type;
    private final Optional<List<SingularityVolume>> volumes;
    private final Optional<SingularityDockerInfo> docker;

    @JsonCreator
    public SingularityContainerInfo(@JsonProperty(value="type") SingularityContainerType type, @JsonProperty(value="volumes") Optional<List<SingularityVolume>> volumes, @JsonProperty(value="docker") Optional<SingularityDockerInfo> docker) {
        this.type = type;
        this.volumes = volumes;
        this.docker = docker;
    }

    @ApiModelProperty(required=true, value="Container type, can be MESOS or DOCKER. Default is MESOS")
    public SingularityContainerType getType() {
        return this.type;
    }

    @ApiModelProperty(required=false, value="List of volumes to mount. Applicable only to DOCKER container type")
    public Optional<List<SingularityVolume>> getVolumes() {
        return this.volumes;
    }

    @ApiModelProperty(required=false, value="Information specific to docker runtime settings")
    public Optional<SingularityDockerInfo> getDocker() {
        return this.docker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityContainerInfo that = (SingularityContainerInfo)o;
        return this.type == that.type && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.docker, that.docker);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.volumes, this.docker});
    }

    public String toString() {
        return "SingularityContainerInfo{type=" + (Object)((Object)this.type) + ", volumes=" + this.volumes + ", docker=" + this.docker + '}';
    }
}

