/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class Resources {
    public static final Resources EMPTY_RESOURCES = new Resources(0.0, 0.0, 0, 0.0);
    private final double cpus;
    private final double memoryMb;
    private final int numPorts;
    private final double diskMb;

    public static Resources add(Resources a, Resources b) {
        Preconditions.checkNotNull(a, "first argument of Resources.add() is null");
        Preconditions.checkNotNull(b, "second argument of Resources.add() is null");
        return new Resources(a.getCpus() + b.getCpus(), a.getMemoryMb() + b.getMemoryMb(), a.getNumPorts() + b.getNumPorts(), a.getDiskMb() + b.getDiskMb());
    }

    public Resources(double cpus, double memoryMb, int numPorts) {
        this(cpus, memoryMb, numPorts, 0.0);
    }

    @JsonCreator
    public Resources(@JsonProperty(value="cpus") double cpus, @JsonProperty(value="memoryMb") double memoryMb, @JsonProperty(value="numPorts") int numPorts, @JsonProperty(value="diskMb") double diskMb) {
        this.cpus = cpus;
        this.memoryMb = memoryMb;
        this.numPorts = numPorts;
        this.diskMb = diskMb;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public double getCpus() {
        return this.cpus;
    }

    public double getMemoryMb() {
        return this.memoryMb;
    }

    public double getDiskMb() {
        return this.diskMb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resources resources = (Resources)o;
        return Double.compare(resources.cpus, this.cpus) == 0 && Double.compare(resources.memoryMb, this.memoryMb) == 0 && this.numPorts == resources.numPorts && Double.compare(resources.diskMb, this.diskMb) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.cpus, this.memoryMb, this.numPorts, this.diskMb);
    }

    public String toString() {
        return "Resources{cpus=" + this.cpus + ", memoryMb=" + this.memoryMb + ", numPorts=" + this.numPorts + ", diskMb=" + this.diskMb + '}';
    }
}

