/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.impl.NullProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class ProtobufDeserializer<T extends Message>
extends StdDeserializer<MessageOrBuilder> {
    private final T defaultInstance;
    private final boolean build;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Map<Descriptors.FieldDescriptor, JsonDeserializer<Object>> deserializerCache;

    public ProtobufDeserializer(Class<T> messageType, boolean build) throws JsonMappingException {
        super(messageType);
        try {
            this.defaultInstance = (Message)messageType.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JsonMappingException("Unable to get default instance for type " + messageType, e);
        }
        this.build = build;
        this.deserializerCache = new ConcurrentHashMap<Descriptors.FieldDescriptor, JsonDeserializer<Object>>();
    }

    @Override
    public MessageOrBuilder deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Message.Builder builder = this.defaultInstance.newBuilderForType();
        this.populate(builder, parser, context);
        if (this.build) {
            return builder.build();
        }
        return builder;
    }

    private void populate(Message.Builder builder, JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            token = parser.nextToken();
        }
        switch (token) {
            case END_OBJECT: {
                return;
            }
            case START_OBJECT: {
                token = parser.nextToken();
                if (token != JsonToken.END_OBJECT) break;
                return;
            }
        }
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        Map<String, Descriptors.FieldDescriptor> fieldLookup = this.buildFieldLookup(descriptor, context);
        do {
            if (!token.equals((Object)JsonToken.FIELD_NAME)) {
                throw context.wrongTokenException(parser, JsonToken.FIELD_NAME, "");
            }
            Descriptors.FieldDescriptor field = fieldLookup.get(parser.getCurrentName());
            if (field == null) {
                if (!context.handleUnknownProperty(parser, this, builder, parser.getCurrentName())) {
                    context.reportUnknownProperty(builder, parser.getCurrentName(), this);
                }
                parser.nextToken();
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
            this.setField(builder, field, parser, context);
        } while ((token = parser.nextToken()) != JsonToken.END_OBJECT);
    }

    private Map<String, Descriptors.FieldDescriptor> buildFieldLookup(Descriptors.Descriptor descriptor, DeserializationContext context) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(context.getConfig().getPropertyNamingStrategy());
        HashMap<String, Descriptors.FieldDescriptor> fieldLookup = Maps.newHashMap();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            fieldLookup.put(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()), field);
        }
        return fieldLookup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setField(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, DeserializationContext context) throws IOException {
        Object value = this.readValue(builder, field, parser, context);
        if (value == null) return;
        if (field.isRepeated()) {
            if (value instanceof Iterable) {
                for (Object subValue : (Iterable)value) {
                    builder.addRepeatedField(field, subValue);
                }
                return;
            } else {
                if (!context.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) throw ProtobufDeserializer.mappingException(field, context);
                builder.addRepeatedField(field, value);
            }
            return;
        } else {
            builder.setField(field, value);
        }
    }

    private Object readValue(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, DeserializationContext context) throws IOException {
        Object value;
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            if (field.isRepeated()) {
                return this.readArray(builder, field, parser, context);
            }
            throw ProtobufDeserializer.mappingException(field, context);
        }
        block0 : switch (field.getJavaType()) {
            case INT: {
                value = this._parseInteger(parser, context);
                if (value != null) break;
                new NullProvider(SimpleType.construct(Integer.TYPE), 0).nullValue(context);
                break;
            }
            case LONG: {
                value = this._parseLong(parser, context);
                if (value != null) break;
                new NullProvider(SimpleType.construct(Long.TYPE), 0L).nullValue(context);
                break;
            }
            case FLOAT: {
                value = this._parseFloat(parser, context);
                if (value != null) break;
                new NullProvider(SimpleType.construct(Float.TYPE), Float.valueOf(0.0f)).nullValue(context);
                break;
            }
            case DOUBLE: {
                value = this._parseDouble(parser, context);
                if (value != null) break;
                new NullProvider(SimpleType.construct(Double.TYPE), 0.0).nullValue(context);
                break;
            }
            case BOOLEAN: {
                value = this._parseBoolean(parser, context);
                if (value != null) break;
                new NullProvider(SimpleType.construct(Boolean.TYPE), false).nullValue(context);
                break;
            }
            case STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        value = parser.getText();
                        break block0;
                    }
                    case VALUE_NULL: {
                        value = null;
                        break block0;
                    }
                }
                value = this._parseString(parser, context);
                break;
            }
            case BYTE_STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        value = ByteString.copyFrom(context.getBase64Variant().decode(parser.getText()));
                        break block0;
                    }
                    case VALUE_NULL: {
                        value = null;
                        break block0;
                    }
                }
                throw ProtobufDeserializer.mappingException(field, context);
            }
            case ENUM: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        value = field.getEnumType().findValueByName(parser.getText());
                        if (value != null || ProtobufDeserializer.ignorableEnum(parser.getText().trim(), context)) break block0;
                        throw context.weirdStringException(parser.getText(), field.getEnumType().getClass(), "value not one of declared Enum instance names");
                    }
                    case VALUE_NUMBER_INT: {
                        if (ProtobufDeserializer.allowNumbersForEnums(context)) {
                            value = field.getEnumType().findValueByNumber(parser.getIntValue());
                            if (value != null || ProtobufDeserializer.ignoreUnknownEnums(context)) break block0;
                            throw context.weirdNumberException(parser.getIntValue(), field.getEnumType().getClass(), "index value outside legal index range " + ProtobufDeserializer.indexRange(field.getEnumType()));
                        }
                        throw context.mappingException("Not allowed to deserialize Enum value out of JSON number (disable DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow)");
                    }
                    case VALUE_NULL: {
                        value = null;
                        break block0;
                    }
                    default: {
                        throw ProtobufDeserializer.mappingException(field, context);
                    }
                }
            }
            case MESSAGE: {
                switch (parser.getCurrentToken()) {
                    case START_OBJECT: {
                        JsonDeserializer<Object> deserializer = this.deserializerCache.get(field);
                        if (deserializer == null) {
                            Message.Builder subBuilder = builder.newBuilderForField(field);
                            Class<?> subType = subBuilder.getDefaultInstanceForType().getClass();
                            SimpleType type = SimpleType.construct(subType);
                            deserializer = context.findContextualValueDeserializer(type, null);
                            this.deserializerCache.put(field, deserializer);
                        }
                        value = deserializer.deserialize(parser, context);
                        break block0;
                    }
                    case VALUE_NULL: {
                        value = null;
                        break block0;
                    }
                }
                throw ProtobufDeserializer.mappingException(field, context);
            }
            default: {
                throw ProtobufDeserializer.mappingException(field, context);
            }
        }
        return value;
    }

    private List<Object> readArray(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, DeserializationContext context) throws IOException {
        ArrayList<Object> values = Lists.newArrayList();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            Object value = this.readValue(builder, field, parser, context);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private static boolean ignorableEnum(String value, DeserializationContext context) {
        return ProtobufDeserializer.acceptEmptyStringAsNull(context) && value.length() == 0 || ProtobufDeserializer.ignoreUnknownEnums(context);
    }

    private static boolean acceptEmptyStringAsNull(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    private static boolean allowNumbersForEnums(DeserializationContext context) {
        return !context.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
    }

    private static boolean ignoreUnknownEnums(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    private static String indexRange(Descriptors.EnumDescriptor field) {
        List<Integer> indices = Lists.transform(field.getValues(), new Function<Descriptors.EnumValueDescriptor, Integer>(){

            @Override
            public Integer apply(@Nonnull Descriptors.EnumValueDescriptor value) {
                return value.getIndex();
            }
        });
        indices = Lists.newArrayList(indices);
        Collections.sort(indices);
        return "[" + Joiner.on(',').join(indices) + "]";
    }

    private static JsonMappingException mappingException(Descriptors.FieldDescriptor field, DeserializationContext context) throws IOException {
        JsonToken token = context.getParser().getCurrentToken();
        String message = "Can not deserialize instance of " + (Object)((Object)field.getJavaType()) + " out of " + (Object)((Object)token) + " token";
        throw context.mappingException(message);
    }
}

