/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.RemoteArtifact;
import java.util.Objects;

public class S3Artifact
extends RemoteArtifact {
    private final String s3Bucket;
    private final String s3ObjectKey;

    @JsonCreator
    public S3Artifact(@JsonProperty(value="name") String name, @JsonProperty(value="filename") String filename, @JsonProperty(value="md5sum") Optional<String> md5sum, @JsonProperty(value="filesize") Optional<Long> filesize, @JsonProperty(value="s3Bucket") String s3Bucket, @JsonProperty(value="s3ObjectKey") String s3ObjectKey, @JsonProperty(value="targetFolderRelativeToTask") Optional<String> targetFolderRelativeToTask) {
        super(name, filename, md5sum, filesize, targetFolderRelativeToTask);
        this.s3Bucket = s3Bucket;
        this.s3ObjectKey = s3ObjectKey;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.s3Bucket, this.s3ObjectKey);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        S3Artifact that = (S3Artifact)other;
        return Objects.equals(this.s3Bucket, that.s3Bucket) && Objects.equals(this.s3ObjectKey, this.s3ObjectKey);
    }

    @Override
    public String toString() {
        return "S3Artifact{s3Bucket='" + this.s3Bucket + '\'' + ", s3ObjectKey='" + this.s3ObjectKey + '\'' + "} " + super.toString();
    }
}

