/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.HealthcheckOptionsBuilder;
import com.hubspot.singularity.HealthcheckProtocol;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class HealthcheckOptions {
    @NotNull
    private final String uri;
    private final Optional<Integer> portIndex;
    private final Optional<Long> portNumber;
    private final Optional<HealthcheckProtocol> protocol;
    private final Optional<Integer> startupTimeoutSeconds;
    private final Optional<Integer> startupDelaySeconds;
    private final Optional<Integer> startupIntervalSeconds;
    private final Optional<Integer> intervalSeconds;
    private final Optional<Integer> responseTimeoutSeconds;
    private final Optional<Integer> maxRetries;
    private final Optional<List<Integer>> failureStatusCodes;

    @JsonCreator
    public HealthcheckOptions(@JsonProperty(value="uri") String uri, @JsonProperty(value="portIndex") Optional<Integer> portIndex, @JsonProperty(value="portNumber") Optional<Long> portNumber, @JsonProperty(value="protocol") Optional<HealthcheckProtocol> protocol, @JsonProperty(value="startupTimeoutSeconds") Optional<Integer> startupTimeoutSeconds, @JsonProperty(value="startupDelaySeconds") Optional<Integer> startupDelaySeconds, @JsonProperty(value="startupIntervalSeconds") Optional<Integer> startupIntervalSeconds, @JsonProperty(value="intervalSeconds") Optional<Integer> intervalSeconds, @JsonProperty(value="responseTimeoutSeconds") Optional<Integer> responseTimeoutSeconds, @JsonProperty(value="maxRetries") Optional<Integer> maxRetries, @JsonProperty(value="failureStatusCodes") Optional<List<Integer>> failureStatusCodes) {
        this.uri = uri;
        this.portIndex = portIndex;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        this.startupDelaySeconds = startupDelaySeconds;
        this.startupIntervalSeconds = startupIntervalSeconds;
        this.intervalSeconds = intervalSeconds;
        this.responseTimeoutSeconds = responseTimeoutSeconds;
        this.maxRetries = maxRetries;
        this.failureStatusCodes = failureStatusCodes;
    }

    @JsonIgnore
    public HealthcheckOptionsBuilder toBuilder() {
        return new HealthcheckOptionsBuilder(this.uri).setPortIndex(this.portIndex).setPortNumber(this.portNumber).setProtocol(this.protocol).setStartupTimeoutSeconds(this.startupTimeoutSeconds).setStartupDelaySeconds(this.startupDelaySeconds).setStartupIntervalSeconds(this.startupIntervalSeconds).setIntervalSeconds(this.intervalSeconds).setResponseTimeoutSeconds(this.responseTimeoutSeconds).setMaxRetries(this.maxRetries).setFailureStatusCodes(this.failureStatusCodes);
    }

    @ApiModelProperty(required=true, value="Healthcheck uri to hit")
    public String getUri() {
        return this.uri;
    }

    @ApiModelProperty(required=false, value="Perform healthcheck on this dynamically allocated port (e.g. 0 for first port), defaults to first port")
    public Optional<Integer> getPortIndex() {
        return this.portIndex;
    }

    @ApiModelProperty(required=false, value="Perform healthcheck on this port (portIndex cannot also be used when using this setting)")
    public Optional<Long> getPortNumber() {
        return this.portNumber;
    }

    @ApiModelProperty(required=false, value="Healthcheck protocol - HTTP or HTTPS")
    public Optional<HealthcheckProtocol> getProtocol() {
        return this.protocol;
    }

    @ApiModelProperty(required=false, value="Consider the task unhealthy/failed if the app has not started responding to healthchecks in this amount of time")
    public Optional<Integer> getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    @ApiModelProperty(required=false, value="Wait this long before issuing the first healthcheck")
    public Optional<Integer> getStartupDelaySeconds() {
        return this.startupDelaySeconds;
    }

    @ApiModelProperty(required=false, value="Time to wait after a failed healthcheck to try again in seconds.")
    public Optional<Integer> getStartupIntervalSeconds() {
        return this.startupIntervalSeconds;
    }

    @ApiModelProperty(required=false, value="Time to wait after a valid but failed healthcheck response to try again in seconds.")
    public Optional<Integer> getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @ApiModelProperty(required=false, value="Single healthcheck HTTP timeout in seconds.")
    public Optional<Integer> getResponseTimeoutSeconds() {
        return this.responseTimeoutSeconds;
    }

    @ApiModelProperty(required=false, value="Maximum number of times to retry an individual healthcheck before failing the deploy.")
    public Optional<Integer> getMaxRetries() {
        return this.maxRetries;
    }

    @ApiModelProperty(required=false, value="Fail the healthcheck with no further retries if one of these status codes is returned")
    public Optional<List<Integer>> getFailureStatusCodes() {
        return this.failureStatusCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthcheckOptions that = (HealthcheckOptions)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.portIndex, that.portIndex) && Objects.equals(this.portNumber, that.portNumber) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.startupTimeoutSeconds, that.startupTimeoutSeconds) && Objects.equals(this.startupDelaySeconds, that.startupDelaySeconds) && Objects.equals(this.startupIntervalSeconds, that.startupIntervalSeconds) && Objects.equals(this.intervalSeconds, that.intervalSeconds) && Objects.equals(this.responseTimeoutSeconds, that.responseTimeoutSeconds) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.failureStatusCodes, that.failureStatusCodes);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.portIndex, this.portNumber, this.protocol, this.startupTimeoutSeconds, this.startupDelaySeconds, this.startupIntervalSeconds, this.intervalSeconds, this.responseTimeoutSeconds, this.maxRetries, this.failureStatusCodes);
    }

    public String toString() {
        return "HealthcheckOptions{uri='" + this.uri + '\'' + ", portIndex=" + this.portIndex + ", portNumber=" + this.portNumber + ", protocol=" + this.protocol + ", startupTimeoutSeconds=" + this.startupTimeoutSeconds + ", startupDelaySeconds=" + this.startupDelaySeconds + ", startupIntervalSeconds=" + this.startupIntervalSeconds + ", intervalSeconds=" + this.intervalSeconds + ", responseTimeoutSeconds=" + this.responseTimeoutSeconds + ", maxRetries=" + this.maxRetries + ", failureStatusCodes=" + this.failureStatusCodes + '}';
    }
}

