/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExecutorDataBuilder;
import com.hubspot.deploy.ExternalArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutorData {
    private final String cmd;
    private final List<EmbeddedArtifact> embeddedArtifacts;
    private final List<ExternalArtifact> externalArtifacts;
    private final List<S3Artifact> s3Artifacts;
    private final List<Integer> successfulExitCodes;
    private final Optional<String> runningSentinel;
    private final Optional<String> user;
    private final List<String> extraCmdLineArgs;
    private final Optional<String> loggingTag;
    private final Map<String, String> loggingExtraFields;
    private final Optional<Long> sigKillProcessesAfterMillis;
    private final Optional<Integer> maxTaskThreads;
    private final Optional<Boolean> preserveTaskSandboxAfterFinish;
    private final Optional<Integer> maxOpenFiles;
    private final Optional<Boolean> skipLogrotateAndCompress;
    private final Optional<List<S3ArtifactSignature>> s3ArtifactSignatures;
    private final Optional<SingularityExecutorLogrotateFrequency> logrotateFrequency;

    @JsonCreator
    public ExecutorData(@JsonProperty(value="cmd") String cmd, @JsonProperty(value="embeddedArtifacts") List<EmbeddedArtifact> embeddedArtifacts, @JsonProperty(value="externalArtifacts") List<ExternalArtifact> externalArtifacts, @JsonProperty(value="s3Artifacts") List<S3Artifact> s3Artifacts, @JsonProperty(value="successfulExitCodes") List<Integer> successfulExitCodes, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="runningSentinel") Optional<String> runningSentinel, @JsonProperty(value="extraCmdLineArgs") List<String> extraCmdLineArgs, @JsonProperty(value="loggingTag") Optional<String> loggingTag, @JsonProperty(value="loggingExtraFields") Map<String, String> loggingExtraFields, @JsonProperty(value="sigKillProcessesAfterMillis") Optional<Long> sigKillProcessesAfterMillis, @JsonProperty(value="maxTaskThreads") Optional<Integer> maxTaskThreads, @JsonProperty(value="preserveTaskSandboxAfterFinish") Optional<Boolean> preserveTaskSandboxAfterFinish, @JsonProperty(value="maxOpenFiles") Optional<Integer> maxOpenFiles, @JsonProperty(value="skipLogrotateAndCompress") Optional<Boolean> skipLogrotateAndCompress, @JsonProperty(value="s3ArtifactSignatures") Optional<List<S3ArtifactSignature>> s3ArtifactSignatures, @JsonProperty(value="logrotateFrequency") Optional<SingularityExecutorLogrotateFrequency> logrotateFrequency) {
        this.cmd = cmd;
        this.embeddedArtifacts = JavaUtils.nonNullImmutable(embeddedArtifacts);
        this.externalArtifacts = JavaUtils.nonNullImmutable(externalArtifacts);
        this.s3Artifacts = JavaUtils.nonNullImmutable(s3Artifacts);
        this.user = user;
        this.successfulExitCodes = JavaUtils.nonNullImmutable(successfulExitCodes);
        this.extraCmdLineArgs = JavaUtils.nonNullImmutable(extraCmdLineArgs);
        this.runningSentinel = runningSentinel;
        this.loggingTag = loggingTag;
        this.loggingExtraFields = JavaUtils.nonNullImmutable(loggingExtraFields);
        this.sigKillProcessesAfterMillis = sigKillProcessesAfterMillis;
        this.maxTaskThreads = maxTaskThreads;
        this.preserveTaskSandboxAfterFinish = preserveTaskSandboxAfterFinish;
        this.maxOpenFiles = maxOpenFiles;
        this.skipLogrotateAndCompress = skipLogrotateAndCompress;
        this.s3ArtifactSignatures = s3ArtifactSignatures;
        this.logrotateFrequency = logrotateFrequency;
    }

    public ExecutorDataBuilder toBuilder() {
        return new ExecutorDataBuilder(this.cmd, this.embeddedArtifacts, this.externalArtifacts, this.s3Artifacts, this.successfulExitCodes, this.runningSentinel, this.user, this.extraCmdLineArgs, this.loggingTag, this.loggingExtraFields, this.sigKillProcessesAfterMillis, this.maxTaskThreads, this.preserveTaskSandboxAfterFinish, this.maxOpenFiles, this.skipLogrotateAndCompress, this.s3ArtifactSignatures, this.logrotateFrequency);
    }

    @ApiModelProperty(required=true, value="Command for the custom executor to run")
    public String getCmd() {
        return this.cmd;
    }

    @ApiModelProperty(required=false)
    public Optional<String> getLoggingTag() {
        return this.loggingTag;
    }

    @ApiModelProperty(required=false)
    public Map<String, String> getLoggingExtraFields() {
        return this.loggingExtraFields;
    }

    @ApiModelProperty(required=false, value="A list of the full content of any embedded artifacts")
    public List<EmbeddedArtifact> getEmbeddedArtifacts() {
        return this.embeddedArtifacts;
    }

    @ApiModelProperty(required=false, value="A list of external artifacts for the executor to download")
    public List<ExternalArtifact> getExternalArtifacts() {
        return this.externalArtifacts;
    }

    @ApiModelProperty(required=false, value="Allowable exit codes for the task to be considered FINISHED instead of FAILED")
    public List<Integer> getSuccessfulExitCodes() {
        return this.successfulExitCodes;
    }

    @ApiModelProperty(required=false, value="Extra arguments in addition to any provided in the cmd field")
    public List<String> getExtraCmdLineArgs() {
        return this.extraCmdLineArgs;
    }

    @ApiModelProperty(required=false)
    public Optional<String> getRunningSentinel() {
        return this.runningSentinel;
    }

    @ApiModelProperty(required=false, value="Run the task process as this user")
    public Optional<String> getUser() {
        return this.user;
    }

    @ApiModelProperty(required=false, value="Send a sigkill to a process if it has not shut down this many millis after being sent a term signal")
    public Optional<Long> getSigKillProcessesAfterMillis() {
        return this.sigKillProcessesAfterMillis;
    }

    @ApiModelProperty(required=false, value="List of s3 artifacts for the executor to download")
    public List<S3Artifact> getS3Artifacts() {
        return this.s3Artifacts;
    }

    @ApiModelProperty(required=false, value="Maximum number of threads a task is allowed to use")
    public Optional<Integer> getMaxTaskThreads() {
        return this.maxTaskThreads;
    }

    @ApiModelProperty(required=false, value="If true, do not delete files in the task sandbox after the task process has terminated")
    public Optional<Boolean> getPreserveTaskSandboxAfterFinish() {
        return this.preserveTaskSandboxAfterFinish;
    }

    @ApiModelProperty(required=false, value="Maximum number of open files the task process is allowed")
    public Optional<Integer> getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    @ApiModelProperty(required=false, value="If true, do not run logrotate or compress old log files")
    public Optional<Boolean> getSkipLogrotateAndCompress() {
        return this.skipLogrotateAndCompress;
    }

    @ApiModelProperty(required=false, value="A list of signatures use to verify downloaded s3artifacts")
    public Optional<List<S3ArtifactSignature>> getS3ArtifactSignatures() {
        return this.s3ArtifactSignatures;
    }

    @ApiModelProperty(required=false, value="Run logrotate this often. Can be HOURLY, DAILY, WEEKLY, MONTHLY")
    public Optional<SingularityExecutorLogrotateFrequency> getLogrotateFrequency() {
        return this.logrotateFrequency;
    }

    public String toString() {
        return "ExecutorData{cmd='" + this.cmd + '\'' + ", embeddedArtifacts=" + this.embeddedArtifacts + ", externalArtifacts=" + this.externalArtifacts + ", s3Artifacts=" + this.s3Artifacts + ", successfulExitCodes=" + this.successfulExitCodes + ", runningSentinel=" + this.runningSentinel + ", user=" + this.user + ", extraCmdLineArgs=" + this.extraCmdLineArgs + ", loggingTag=" + this.loggingTag + ", loggingExtraFields=" + this.loggingExtraFields + ", sigKillProcessesAfterMillis=" + this.sigKillProcessesAfterMillis + ", maxTaskThreads=" + this.maxTaskThreads + ", preserveTaskSandboxAfterFinish=" + this.preserveTaskSandboxAfterFinish + ", maxOpenFiles=" + this.maxOpenFiles + ", skipLogrotateAndCompress=" + this.skipLogrotateAndCompress + ", s3ArtifactSignatures=" + this.s3ArtifactSignatures + ", logrotateFrequency=" + this.logrotateFrequency + '}';
    }
}

