/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Optional;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Artifact {
    private final String name;
    private final String filename;
    private final Optional<String> md5sum;
    private final Optional<String> targetFolderRelativeToTask;

    public Artifact(String name, String filename, Optional<String> md5sum, Optional<String> targetFolderRelativeToTask) {
        this.name = name;
        this.filename = filename;
        this.md5sum = md5sum;
        this.targetFolderRelativeToTask = targetFolderRelativeToTask;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    @JsonIgnore
    public String getFilenameForCache() {
        if (this.md5sum.isPresent()) {
            return String.format("%s-%s", this.md5sum.get(), this.filename);
        }
        return this.filename;
    }

    public Optional<String> getMd5sum() {
        return this.md5sum;
    }

    public Optional<String> getTargetFolderRelativeToTask() {
        return this.targetFolderRelativeToTask;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.filename, this.md5sum, this.targetFolderRelativeToTask);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Artifact that = (Artifact)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.filename, that.filename) && Objects.equals(this.md5sum, that.md5sum) && Objects.equals(this.targetFolderRelativeToTask, that.targetFolderRelativeToTask);
    }

    public String toString() {
        return "Artifact{name='" + this.name + '\'' + ", filename='" + this.filename + '\'' + ", md5sum=" + this.md5sum + ", targetFolderRelativeToTask=" + this.targetFolderRelativeToTask + '}';
    }
}

