/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.hubspot.baragon.models.BaragonService;
import com.hubspot.baragon.models.RequestAction;
import com.hubspot.baragon.models.UpstreamInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonRequest {
    @NotNull
    @Pattern(regexp="[^\\s/|]+", message="cannot contain whitespace, '/', or '|'", flags={Pattern.Flag.MULTILINE})
    private final String loadBalancerRequestId;
    @NotNull
    @Valid
    private final BaragonService loadBalancerService;
    @NotNull
    @Valid
    private final List<UpstreamInfo> addUpstreams;
    @NotNull
    @Valid
    private final List<UpstreamInfo> removeUpstreams;
    private final Optional<String> replaceServiceId;
    private final Optional<RequestAction> action;
    @Valid
    private final List<UpstreamInfo> replaceUpstreams;
    @NotNull
    private final boolean noValidate;
    @NotNull
    private final boolean noReload;

    @JsonCreator
    public BaragonRequest(@JsonProperty(value="loadBalancerRequestId") String loadBalancerRequestId, @JsonProperty(value="loadBalancerService") BaragonService loadBalancerService, @JsonProperty(value="addUpstreams") List<UpstreamInfo> addUpstreams, @JsonProperty(value="removeUpstreams") List<UpstreamInfo> removeUpstreams, @JsonProperty(value="replaceUpstreams") List<UpstreamInfo> replaceUpstreams, @JsonProperty(value="replaceServiceId") Optional<String> replaceServiceId, @JsonProperty(value="action") Optional<RequestAction> action, @JsonProperty(value="noValidate") boolean noValidate, @JsonProperty(value="noReload") boolean noReload) {
        this.loadBalancerRequestId = loadBalancerRequestId;
        this.loadBalancerService = loadBalancerService;
        this.addUpstreams = this.addRequestId(addUpstreams, loadBalancerRequestId);
        this.removeUpstreams = this.addRequestId(removeUpstreams, loadBalancerRequestId);
        this.replaceServiceId = replaceServiceId;
        this.action = action;
        this.replaceUpstreams = Objects.firstNonNull(replaceUpstreams, Collections.emptyList());
        this.noValidate = Objects.firstNonNull(noValidate, false);
        this.noReload = noReload;
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, List<UpstreamInfo> replaceUpstreams, Optional<String> replaceServiceId, Optional<RequestAction> action) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, replaceUpstreams, replaceServiceId, action, false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, Collections.emptyList(), Optional.absent(), Optional.of(RequestAction.UPDATE), false, false);
    }

    public BaragonRequest(String loadBalancerRequestId, BaragonService loadBalancerService, List<UpstreamInfo> addUpstreams, List<UpstreamInfo> removeUpstreams, Optional<String> replaceServiceId) {
        this(loadBalancerRequestId, loadBalancerService, addUpstreams, removeUpstreams, Collections.emptyList(), replaceServiceId, Optional.of(RequestAction.UPDATE), false, false);
    }

    public String getLoadBalancerRequestId() {
        return this.loadBalancerRequestId;
    }

    public BaragonService getLoadBalancerService() {
        return this.loadBalancerService;
    }

    public List<UpstreamInfo> getAddUpstreams() {
        return this.addUpstreams;
    }

    public List<UpstreamInfo> getRemoveUpstreams() {
        return this.removeUpstreams;
    }

    public List<UpstreamInfo> getReplaceUpstreams() {
        return this.replaceUpstreams;
    }

    public Optional<String> getReplaceServiceId() {
        return this.replaceServiceId;
    }

    public Optional<RequestAction> getAction() {
        return this.action;
    }

    private List<UpstreamInfo> addRequestId(List<UpstreamInfo> upstreams, String requestId) {
        if (upstreams == null || requestId == null) {
            return upstreams;
        }
        ArrayList<UpstreamInfo> upstreamsWithRequestId = Lists.newArrayListWithCapacity(upstreams.size());
        for (UpstreamInfo upstream : upstreams) {
            upstreamsWithRequestId.add(this.addRequestId(upstream, requestId));
        }
        return upstreamsWithRequestId;
    }

    private UpstreamInfo addRequestId(UpstreamInfo upstream, String requestId) {
        if (!upstream.getRequestId().isPresent()) {
            return new UpstreamInfo(upstream.getUpstream(), Optional.of(requestId), upstream.getRackId(), Optional.of(upstream.getGroup()));
        }
        return upstream;
    }

    public boolean isNoValidate() {
        return this.noValidate;
    }

    public boolean isNoReload() {
        return this.noReload;
    }

    public String toString() {
        return "BaragonRequest [loadBalancerRequestId='" + this.loadBalancerRequestId + '\'' + ", loadBalancerService=" + this.loadBalancerService + ", addUpstreams=" + this.addUpstreams + ", removeUpstreams=" + this.removeUpstreams + ", replaceServiceId=" + this.replaceServiceId + ", action=" + this.action + ", noValidate=" + this.noValidate + ", noReload=" + this.noReload + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonRequest request = (BaragonRequest)o;
        if (!this.addUpstreams.equals(request.addUpstreams)) {
            return false;
        }
        if (!this.loadBalancerRequestId.equals(request.loadBalancerRequestId)) {
            return false;
        }
        if (!this.loadBalancerService.equals(request.loadBalancerService)) {
            return false;
        }
        if (!this.removeUpstreams.equals(request.removeUpstreams)) {
            return false;
        }
        if (!this.replaceServiceId.equals(request.replaceServiceId)) {
            return false;
        }
        if (!this.action.equals(request.getAction())) {
            return false;
        }
        if (!this.noValidate == request.noValidate) {
            return false;
        }
        return !this.noReload != request.noReload;
    }

    public int hashCode() {
        int result = this.loadBalancerRequestId.hashCode();
        result = 31 * result + this.loadBalancerService.hashCode();
        result = 31 * result + this.addUpstreams.hashCode();
        result = 31 * result + this.removeUpstreams.hashCode();
        result = 31 * result + this.replaceServiceId.hashCode();
        result = 31 * result + this.action.hashCode();
        result = 31 * result + (this.noValidate ? 1 : 0);
        result = 31 * result + (this.noReload ? 1 : 0);
        return result;
    }
}

