/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonGroup {
    private final String name;
    @Deprecated
    private Optional<String> domain;
    private Set<String> sources;
    private Optional<String> defaultDomain;
    private Set<String> domains;

    @JsonCreator
    public BaragonGroup(@JsonProperty(value="name") String name, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="sources") Set<String> sources, @JsonProperty(value="defaultDomain") Optional<String> defaultDomain, @JsonProperty(value="domains") Set<String> domains) {
        this.name = name;
        this.domain = domain;
        this.sources = Objects.firstNonNull(sources, Collections.emptySet());
        this.defaultDomain = defaultDomain;
        this.domains = Objects.firstNonNull(domains, Collections.emptySet());
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Optional<String> getDomain() {
        return this.getDefaultDomain();
    }

    @Deprecated
    public void setDomain(Optional<String> domain) {
        this.domain = domain;
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public void setSources(Set<String> sources) {
        this.sources = sources;
    }

    public Optional<String> getDefaultDomain() {
        return this.defaultDomain.or(this.domain);
    }

    public void setDefaultDomain(Optional<String> defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonGroup that = (BaragonGroup)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.domain.equals(that.domain)) {
            return false;
        }
        if (!this.sources.equals(that.sources)) {
            return false;
        }
        if (!this.defaultDomain.equals(that.defaultDomain)) {
            return false;
        }
        return this.domains.equals(that.domains);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + this.sources.hashCode();
        result = 31 * result + this.defaultDomain.hashCode();
        result = 31 * result + this.domains.hashCode();
        return result;
    }

    public String toString() {
        return "BaragonGroup [name=" + this.name + ", domain=" + this.domain + ", sources=" + this.sources + ", defaultDomain=" + this.defaultDomain + ", domains=" + this.domains + ']';
    }
}

