/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonServiceException;
import java.util.HashSet;
import java.util.Set;

public class RetryUtils {
    private static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(6);
    private static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(5);

    public static boolean isRetryableServiceException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        int statusCode = ase.getStatusCode();
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    public static boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return THROTTLING_ERROR_CODES.contains(ase.getErrorCode());
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException ase) {
        return ase != null && ase.getStatusCode() == 413;
    }

    public static boolean isClockSkewError(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return CLOCK_SKEW_ERROR_CODES.contains(ase.getErrorCode());
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("LimitExceededException");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
    }
}

