/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorDockerAuthConfig;
import com.hubspot.singularity.executor.handlebars.BashEscapedHelper;
import com.hubspot.singularity.executor.handlebars.EscapedNewLinesHelper;
import com.hubspot.singularity.executor.handlebars.IfHasNewLinesHelper;
import com.hubspot.singularity.executor.handlebars.IfPresentHelper;
import com.hubspot.singularity.runner.base.config.SingularityRunnerBaseLogging;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.extra.ThrottleRequestFilter;
import com.ning.http.client.filter.RequestFilter;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.AuthConfig;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingularityExecutorModule
extends AbstractModule {
    public static final String RUNNER_TEMPLATE = "runner.sh";
    public static final String ENVIRONMENT_TEMPLATE = "deploy.env";
    public static final String LOGROTATE_TEMPLATE = "logrotate.conf";
    public static final String LOGROTATE_CRON_TEMPLATE = "logrotate.cron";
    public static final String DOCKER_TEMPLATE = "docker.sh";
    public static final String LOCAL_DOWNLOAD_HTTP_CLIENT = "SingularityExecutorModule.local.download.http.client";
    public static final String ALREADY_SHUT_DOWN = "already.shut.down";

    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="SingularityExecutorModule.local.download.http.client")
    public AsyncHttpClient providesHttpClient(SingularityExecutorConfiguration configuration) {
        AsyncHttpClientConfig.Builder configBldr = new AsyncHttpClientConfig.Builder();
        configBldr.setRequestTimeoutInMs((int)configuration.getLocalDownloadServiceTimeoutMillis());
        configBldr.setIdleConnectionTimeoutInMs((int)configuration.getLocalDownloadServiceTimeoutMillis());
        configBldr.addRequestFilter((RequestFilter)new ThrottleRequestFilter(configuration.getLocalDownloadServiceMaxConnections()));
        return new AsyncHttpClient(configBldr.build());
    }

    @Provides
    @Singleton
    @Named(value="runner.sh")
    public Template providesRunnerTemplate(Handlebars handlebars) throws IOException {
        return handlebars.compile(RUNNER_TEMPLATE);
    }

    @Provides
    @Singleton
    @Named(value="deploy.env")
    public Template providesEnvironmentTemplate(Handlebars handlebars) throws IOException {
        return handlebars.compile(ENVIRONMENT_TEMPLATE);
    }

    @Provides
    @Singleton
    @Named(value="logrotate.conf")
    public Template providesLogrotateTemplate(Handlebars handlebars) throws IOException {
        return handlebars.compile(LOGROTATE_TEMPLATE);
    }

    @Provides
    @Singleton
    @Named(value="logrotate.cron")
    public Template providesLogrotateCronTemplate(Handlebars handlebars) throws IOException {
        return handlebars.compile(LOGROTATE_CRON_TEMPLATE);
    }

    @Provides
    @Singleton
    @Named(value="docker.sh")
    public Template providesDockerTempalte(Handlebars handlebars) throws IOException {
        return handlebars.compile(DOCKER_TEMPLATE);
    }

    @Provides
    @Singleton
    public Handlebars providesHandlebars() {
        SingularityRunnerBaseLogging.quietEagerLogging();
        Handlebars handlebars = new Handlebars();
        handlebars.registerHelper("bashEscaped", (Helper)new BashEscapedHelper());
        handlebars.registerHelper("ifPresent", (Helper)new IfPresentHelper());
        handlebars.registerHelper("ifHasNewLines", (Helper)new IfHasNewLinesHelper());
        handlebars.registerHelper("escapedNewLines", (Helper)new EscapedNewLinesHelper());
        return handlebars;
    }

    @Provides
    @Singleton
    public DockerClient providesDockerClient(SingularityExecutorConfiguration configuration) {
        DefaultDockerClient.Builder dockerClientBuilder = DefaultDockerClient.builder().uri(URI.create("unix://localhost/var/run/docker.sock")).connectionPoolSize(configuration.getDockerClientConnectionPoolSize());
        if (configuration.getDockerAuthConfig().isPresent()) {
            SingularityExecutorDockerAuthConfig authConfig = (SingularityExecutorDockerAuthConfig)configuration.getDockerAuthConfig().get();
            dockerClientBuilder.authConfig(AuthConfig.builder().email(authConfig.getEmail()).username(authConfig.getUsername()).password(authConfig.getPassword()).serverAddress(authConfig.getServerAddress()).build());
        }
        return dockerClientBuilder.build();
    }

    @Provides
    @Singleton
    @Named(value="already.shut.down")
    public AtomicBoolean providesAlreadyShutDown() {
        return new AtomicBoolean(false);
    }
}

