/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityId;
import com.hubspot.singularity.SingularityPendingTaskId;
import java.util.ArrayList;
import java.util.List;

public class SingularityTaskId
extends SingularityId {
    private final String requestId;
    private final long startedAt;
    private final int instanceNo;
    private final String host;
    private final String rackId;

    @JsonCreator
    public SingularityTaskId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="nextRunAt") long startedAt, @JsonProperty(value="instanceNo") int instanceNo, @JsonProperty(value="host") String host, @JsonProperty(value="rackId") String rackId) {
        this.requestId = requestId;
        this.startedAt = startedAt;
        this.instanceNo = instanceNo;
        this.rackId = rackId;
        this.host = host;
    }

    public static List<SingularityTaskId> filter(List<SingularityTaskId> taskIds, String requestId) {
        ArrayList matching = Lists.newArrayList();
        for (SingularityTaskId taskId : taskIds) {
            if (!taskId.getRequestId().equals(requestId)) continue;
            matching.add(taskId);
        }
        return matching;
    }

    public String getRackId() {
        return this.rackId;
    }

    public String getHost() {
        return this.host;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public int getInstanceNo() {
        return this.instanceNo;
    }

    public boolean matches(SingularityPendingTaskId pendingTaskId) {
        return this.getRequestId().equals(pendingTaskId.getRequestId());
    }

    public static SingularityTaskId fromString(String string) {
        String[] splits = JavaUtils.reverseSplit(string, 5, "-");
        String requestId = splits[0];
        long startedAt = Long.parseLong(splits[1]);
        int instanceNo = Integer.parseInt(splits[2]);
        String host = splits[3];
        String rackId = splits[4];
        return new SingularityTaskId(requestId, startedAt, instanceNo, host, rackId);
    }

    public String toString() {
        return String.format("%s-%s-%s-%s-%s", this.getRequestId(), this.getStartedAt(), this.getInstanceNo(), this.getHost(), this.getRackId());
    }
}

