/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityJsonObject;

public class SingularityTaskCleanup
extends SingularityJsonObject {
    private final Optional<String> user;
    private final TaskCleanupType cleanupType;
    private final long timestamp;
    private final String taskId;
    private final String requestId;

    @JsonCreator
    public SingularityTaskCleanup(@JsonProperty(value="user") Optional<String> user, @JsonProperty(value="cleanupType") String cleanupType, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskId") String taskId, @JsonProperty(value="requestId") String requestId) {
        this(user, TaskCleanupType.valueOf(cleanupType), timestamp, taskId, requestId);
    }

    public SingularityTaskCleanup(Optional<String> user, TaskCleanupType cleanupType, long timestamp, String taskId, String requestId) {
        this.user = user;
        this.cleanupType = cleanupType;
        this.timestamp = timestamp;
        this.taskId = taskId;
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    @JsonIgnore
    public TaskCleanupType getCleanupTypeEnum() {
        return this.cleanupType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getCleanupType() {
        return this.cleanupType.name();
    }

    public static SingularityTaskCleanup fromBytes(byte[] bytes, ObjectMapper objectMapper) throws Exception {
        return (SingularityTaskCleanup)objectMapper.readValue(bytes, SingularityTaskCleanup.class);
    }

    public String toString() {
        return "SingularityTaskCleanup [user=" + this.user + ", cleanupType=" + (Object)((Object)this.cleanupType) + ", timestamp=" + this.timestamp + ", taskId=" + this.taskId + ", requestId=" + this.requestId + "]";
    }

    public static enum TaskCleanupType {
        USER_REQUESTED,
        DECOMISSIONING,
        SCALING_DOWN,
        BOUNCING;

    }
}

