/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityJsonObject;

public class SingularityRequestCleanup
extends SingularityJsonObject {
    private final Optional<String> user;
    private final RequestCleanupType cleanupType;
    private final long timestamp;
    private final String requestId;

    @JsonCreator
    public SingularityRequestCleanup(@JsonProperty(value="user") Optional<String> user, @JsonProperty(value="cleanupType") String cleanupType, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="requestId") String requestId) {
        this(user, RequestCleanupType.valueOf(cleanupType), timestamp, requestId);
    }

    public SingularityRequestCleanup(Optional<String> user, RequestCleanupType cleanupType, long timestamp, String requestId) {
        this.user = user;
        this.cleanupType = cleanupType;
        this.timestamp = timestamp;
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    @JsonIgnore
    public RequestCleanupType getCleanupTypeEnum() {
        return this.cleanupType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getCleanupType() {
        return this.cleanupType.name();
    }

    public static SingularityRequestCleanup fromBytes(byte[] bytes, ObjectMapper objectMapper) throws Exception {
        return (SingularityRequestCleanup)objectMapper.readValue(bytes, SingularityRequestCleanup.class);
    }

    public String toString() {
        return "SingularityRequestCleanup [user=" + this.user + ", cleanupType=" + (Object)((Object)this.cleanupType) + ", timestamp=" + this.timestamp + ", requestId=" + this.requestId + "]";
    }

    public static enum RequestCleanupType {
        DELETING,
        PAUSING;

    }
}

