/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hubspot.mesos.Resources;
import com.hubspot.singularity.SingularityJsonObject;
import com.hubspot.singularity.SingularityRequestBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SingularityRequest
extends SingularityJsonObject {
    private final String id;
    private final String name;
    private final String version;
    private final Long timestamp;
    private final Map<String, String> metadata;
    private final String executor;
    private final Resources resources;
    private final String schedule;
    private final Integer instances;
    private final Boolean rackSensitive;
    private final Boolean daemon;
    private final String command;
    private final Map<String, String> env;
    private final List<String> uris;
    private final Object executorData;
    private final List<String> owners;
    private final Integer numRetriesOnFailure;
    private final Integer maxFailuresBeforePausing;
    private final Boolean pauseOnInitialFailure;

    public static SingularityRequestBuilder newBuilder() {
        return new SingularityRequestBuilder();
    }

    @JsonCreator
    public SingularityRequest(@JsonProperty(value="command") String command, @JsonProperty(value="name") String name, @JsonProperty(value="executor") String executor, @JsonProperty(value="resources") Resources resources, @JsonProperty(value="schedule") String schedule, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="daemon") Boolean daemon, @JsonProperty(value="env") Map<String, String> env, @JsonProperty(value="uris") List<String> uris, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="executorData") Object executorData, @JsonProperty(value="rackSensitive") Boolean rackSensitive, @JsonProperty(value="id") String id, @JsonProperty(value="version") String version, @JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="owners") List<String> owners, @JsonProperty(value="numRetriesOnFailure") Integer numRetriesOnFailure, @JsonProperty(value="maxFailuresBeforePausing") Integer maxFailuresBeforePausing, @JsonProperty(value="pauseOnInitialFailure") Boolean pauseOnInitialFailure) {
        this.command = command;
        this.name = name;
        this.resources = resources;
        this.executor = executor;
        this.schedule = schedule;
        this.daemon = daemon;
        this.instances = instances;
        this.rackSensitive = rackSensitive;
        this.metadata = metadata;
        this.version = version;
        this.id = id;
        this.timestamp = timestamp;
        this.env = env;
        this.uris = uris;
        this.executorData = executorData;
        this.owners = owners;
        this.numRetriesOnFailure = numRetriesOnFailure;
        this.maxFailuresBeforePausing = maxFailuresBeforePausing;
        this.pauseOnInitialFailure = pauseOnInitialFailure;
    }

    public List<String> getOwners() {
        if (this.owners == null) {
            return Collections.emptyList();
        }
        return this.owners;
    }

    public Integer getMaxFailuresBeforePausing() {
        return this.maxFailuresBeforePausing;
    }

    public Integer getNumRetriesOnFailure() {
        return this.numRetriesOnFailure;
    }

    public SingularityRequestBuilder toBuilder() {
        return new SingularityRequestBuilder().setCommand(this.command).setName(this.name).setResources(this.resources).setExecutor(this.executor).setSchedule(this.schedule).setDaemon(this.daemon).setInstances(this.instances).setRackSensitive(this.rackSensitive).setMetadata(this.metadata == null ? null : Maps.newHashMap(this.metadata)).setVersion(this.version).setId(this.id).setTimestamp(this.timestamp).setNumRetriesOnFailure(this.numRetriesOnFailure).setMaxFailuresBeforePausing(this.maxFailuresBeforePausing).setEnv(this.env == null ? null : Maps.newHashMap(this.env)).setUris(this.uris == null ? null : Lists.newArrayList(this.uris)).setExecutorData(this.executorData);
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public Object getExecutorData() {
        return this.executorData;
    }

    public Boolean getRackSensitive() {
        return this.rackSensitive;
    }

    public static SingularityRequest fromBytes(byte[] bytes, ObjectMapper objectMapper) throws Exception {
        return (SingularityRequest)objectMapper.readValue(bytes, SingularityRequest.class);
    }

    public Integer getInstances() {
        return this.instances;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    @JsonIgnore
    public boolean isRackSensitive() {
        return this.rackSensitive != null && this.rackSensitive != false;
    }

    @JsonIgnore
    public boolean alwaysRunning() {
        return (this.daemon == null || this.daemon != false) && !this.isScheduled();
    }

    @JsonIgnore
    public boolean isScheduled() {
        return this.schedule != null;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getName() {
        return this.name;
    }

    public String getExecutor() {
        return this.executor;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getCommand() {
        return this.command;
    }

    public Boolean getPauseOnInitialFailure() {
        return this.pauseOnInitialFailure;
    }

    public String toString() {
        return "SingularityRequest [id=" + this.id + ", name=" + this.name + ", version=" + this.version + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + ", executor=" + this.executor + ", resources=" + this.resources + ", schedule=" + this.schedule + ", instances=" + this.instances + ", rackSensitive=" + this.rackSensitive + ", daemon=" + this.daemon + ", command=" + this.command + ", env=" + this.env + ", uris=" + this.uris + ", executorData=" + this.executorData + ", owners=" + this.owners + ", numRetriesOnFailure=" + this.numRetriesOnFailure + ", maxFailuresBeforePausing=" + this.maxFailuresBeforePausing + ", pauseOnInitialFailure=" + this.pauseOnInitialFailure + "]";
    }
}

