/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityId;
import com.hubspot.singularity.SingularityPendingRequestId;
import java.util.ArrayList;
import java.util.List;

public class SingularityPendingTaskId
extends SingularityId
implements Comparable<SingularityPendingTaskId> {
    private final String requestId;
    private final long nextRunAt;
    private final int instanceNo;
    private final SingularityPendingRequestId.PendingType pendingType;

    @JsonCreator
    public SingularityPendingTaskId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="nextRunAt") long nextRunAt, @JsonProperty(value="instanceNo") int instanceNo, @JsonProperty(value="pendingType") String pendingType) {
        this(requestId, nextRunAt, instanceNo, SingularityPendingRequestId.PendingType.valueOf(pendingType));
    }

    public SingularityPendingTaskId(String requestId, long nextRunAt, int instanceNo, SingularityPendingRequestId.PendingType pendingType) {
        this.requestId = requestId;
        this.nextRunAt = nextRunAt;
        this.instanceNo = instanceNo;
        this.pendingType = pendingType;
    }

    public static List<SingularityPendingTaskId> filter(List<SingularityPendingTaskId> taskIds, String requestId) {
        ArrayList matching = Lists.newArrayList();
        for (SingularityPendingTaskId taskId : taskIds) {
            if (!taskId.getRequestId().equals(requestId)) continue;
            matching.add(taskId);
        }
        return matching;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getNextRunAt() {
        return this.nextRunAt;
    }

    public int getInstanceNo() {
        return this.instanceNo;
    }

    public String getPendingType() {
        return this.pendingType.name();
    }

    @JsonIgnore
    public SingularityPendingRequestId.PendingType getPendingTypeEnum() {
        return this.pendingType;
    }

    public static SingularityPendingTaskId fromString(String string) {
        String[] splits = JavaUtils.reverseSplit(string, 4, "-");
        String requestId = splits[0];
        long nextRunAt = Long.parseLong(splits[1]);
        int instanceNo = Integer.parseInt(splits[2]);
        SingularityPendingRequestId.PendingType pendingType = SingularityPendingRequestId.PendingType.valueOf(splits[3]);
        return new SingularityPendingTaskId(requestId, nextRunAt, instanceNo, pendingType);
    }

    public String toString() {
        return String.format("%s-%s-%s-%s", this.getRequestId(), this.getNextRunAt(), this.getInstanceNo(), this.getPendingType());
    }

    @Override
    public int compareTo(SingularityPendingTaskId o) {
        return ComparisonChain.start().compare(this.getNextRunAt(), o.getNextRunAt()).compare((Comparable)((Object)this.getRequestId()), (Comparable)((Object)o.getRequestId())).compare(this.getInstanceNo(), o.getInstanceNo()).compare((Comparable)((Object)this.getPendingType()), (Comparable)((Object)o.getPendingType())).result();
    }
}

