/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.SingularityId;

public class SingularityPendingRequestId
extends SingularityId {
    private final String requestId;
    private final PendingType pendingType;

    public SingularityPendingRequestId(String requestId) {
        this(requestId, PendingType.REGULAR);
    }

    public SingularityPendingRequestId(String requestId, PendingType pendingType) {
        this.requestId = requestId;
        this.pendingType = pendingType;
    }

    @JsonCreator
    public SingularityPendingRequestId(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="pendingType") String pendingType) {
        this(requestId, PendingType.valueOf(pendingType));
    }

    public String getRequestId() {
        return this.requestId;
    }

    @JsonIgnore
    public PendingType getPendingTypeEnum() {
        return this.pendingType;
    }

    public String getPendingType() {
        return this.pendingType.name();
    }

    public static SingularityPendingRequestId fromString(String string) {
        String[] splits = JavaUtils.reverseSplit(string, 2, "-");
        return new SingularityPendingRequestId(splits[0], splits[1]);
    }

    public String toString() {
        return String.format("%s-%s", new Object[]{this.requestId, this.pendingType});
    }

    public static enum PendingType {
        IMMEDIATE,
        STARTUP,
        REGULAR,
        UNPAUSED,
        RETRY,
        BOUNCE;

    }
}

