/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.google.common.base.Throwables;
import com.google.common.net.InetAddresses;
import com.hubspot.mesos.Resources;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.mesos.Protos;

public class MesosUtils {
    public static final String CPUS = "cpus";
    public static final String MEMORY = "mem";
    public static final String PORTS = "ports";

    private static int getScalar(Protos.Resource r) {
        return (int)r.getScalar().getValue();
    }

    private static int getScalar(Protos.Offer offer, String name) {
        for (Protos.Resource r : offer.getResourcesList()) {
            if (!r.hasName() || !r.getName().equals(name) || !r.hasScalar()) continue;
            return MesosUtils.getScalar(r);
        }
        return 0;
    }

    private static Protos.Value.Ranges getRanges(Protos.Offer offer, String name) {
        for (Protos.Resource r : offer.getResourcesList()) {
            if (!r.hasName() || !r.getName().equals(name) || !r.hasRanges()) continue;
            return r.getRanges();
        }
        return null;
    }

    private static int getNumRanges(Protos.Offer offer, String name) {
        int totalRanges = 0;
        Protos.Value.Ranges ranges = MesosUtils.getRanges(offer, name);
        if (ranges == null) {
            return 0;
        }
        for (Protos.Value.Range range : ranges.getRangeList()) {
            long num = range.getEnd() - range.getBegin();
            totalRanges = (int)((long)totalRanges + num);
        }
        return totalRanges;
    }

    public static Protos.Resource getCpuResource(int cpus) {
        return MesosUtils.newScalar(CPUS, cpus);
    }

    public static Protos.Resource getMemoryResource(int memory) {
        return MesosUtils.newScalar(MEMORY, memory);
    }

    public static long[] getPorts(Protos.Resource portsResource, int numPorts) {
        long[] ports = new long[numPorts];
        int idx = 0;
        for (Protos.Value.Range r : portsResource.getRanges().getRangeList()) {
            long port = r.getBegin();
            while (port < r.getEnd()) {
                ports[idx++] = port++;
            }
        }
        return ports;
    }

    public static Protos.Resource getPortsResource(int numPorts, Protos.Offer offer) {
        Protos.Value.Ranges ranges = MesosUtils.getRanges(offer, PORTS);
        if (ranges == null) {
            throw new IllegalStateException(String.format("Ports %s should have existed in offer %s", PORTS, offer));
        }
        Protos.Value.Ranges.Builder rangesBldr = Protos.Value.Ranges.newBuilder();
        int portsSoFar = 0;
        for (Protos.Value.Range range : ranges.getRangeList()) {
            long rangeEnd = Math.min((long)(numPorts - portsSoFar) + range.getBegin(), range.getEnd());
            long numPortsInRange = rangeEnd - range.getBegin();
            rangesBldr.addRange(Protos.Value.Range.newBuilder().setBegin(range.getBegin()).setEnd(rangeEnd));
            if ((portsSoFar = (int)((long)portsSoFar + numPortsInRange)) != numPorts) continue;
            break;
        }
        return Protos.Resource.newBuilder().setType(Protos.Value.Type.RANGES).setName(PORTS).setRanges(rangesBldr).build();
    }

    private static Protos.Resource newScalar(String name, int value) {
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue((double)value).build()).build();
    }

    public static int getNumCpus(Protos.Offer offer) {
        return MesosUtils.getScalar(offer, CPUS);
    }

    public static int getMemory(Protos.Offer offer) {
        return MesosUtils.getScalar(offer, MEMORY);
    }

    public static int getNumPorts(Protos.Offer offer) {
        return MesosUtils.getNumRanges(offer, PORTS);
    }

    public static boolean doesOfferMatchResources(Resources resources, Protos.Offer offer) {
        int numCpus = MesosUtils.getNumCpus(offer);
        if (numCpus < resources.getCpus()) {
            return false;
        }
        int memory = MesosUtils.getMemory(offer);
        if (memory < resources.getMemoryMb()) {
            return false;
        }
        int numPorts = MesosUtils.getNumPorts(offer);
        return numPorts >= resources.getNumPorts();
    }

    public static boolean isTaskFailed(Protos.TaskState state) {
        return state == Protos.TaskState.TASK_FAILED || state == Protos.TaskState.TASK_LOST || state == Protos.TaskState.TASK_KILLED;
    }

    public static boolean isTaskDone(Protos.TaskState state) {
        return state == Protos.TaskState.TASK_FAILED || state == Protos.TaskState.TASK_LOST || state == Protos.TaskState.TASK_KILLED || state == Protos.TaskState.TASK_FINISHED;
    }

    public static String getMasterHostAndPort(Protos.MasterInfo masterInfo) {
        byte[] fromIp = ByteBuffer.allocate(4).putInt(masterInfo.getIp()).array();
        try {
            return String.format("%s:%s", InetAddresses.fromLittleEndianByteArray((byte[])fromIp).getHostAddress(), masterInfo.getPort());
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

