/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;

public class JavaUtils {
    private static final String CHARSET_UTF = "UTF-8";

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes(CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, CHARSET_UTF);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String[] reverseSplit(String string, int numItems, String separator) {
        String[] splits = string.split("\\" + separator);
        String[] reverseSplit = new String[numItems];
        for (int i = 1; i < numItems; ++i) {
            reverseSplit[numItems - i] = splits[splits.length - i];
        }
        StringBuilder lastItemBldr = new StringBuilder();
        for (int s = 0; s < splits.length - numItems + 1; ++s) {
            lastItemBldr.append(splits[s]);
            if (s >= splits.length - numItems) continue;
            lastItemBldr.append(separator);
        }
        reverseSplit[0] = lastItemBldr.toString();
        return reverseSplit;
    }

    public static String getHostAddress() throws Exception {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress current_addr = addresses.nextElement();
                if (current_addr.isLoopbackAddress() || !(current_addr instanceof Inet4Address)) continue;
                return current_addr.getHostAddress();
            }
        }
        throw new RuntimeException("Couldn't deduce host address");
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

