package code.complete.log.printer;

import android.support.annotation.NonNull;
import android.util.Log;

import code.complete.log.LogInfo;
import code.complete.log.LogPrinter;

/**
 * Android Logcat Printer
 * @author imkarl
 */
public final class AndroidPrinter implements LogPrinter {

    // 单行最大输出长度
    private static final int MAX_LINE_LENGTH = 3000;

    private final boolean isShowThread;
    public AndroidPrinter(boolean showThread) {
        this.isShowThread = showThread;
    }

    @Override
    public void println(@NonNull LogInfo infos, @NonNull final String message) {
        StringBuilder describe = new StringBuilder(infos.getCallerString());
        if (isShowThread) {
            describe.append('\t').append("[Thread: ").append(infos.getThreadName()).append(']');
        }
        Log.println(infos.getPriority(), infos.getTag(), describe.toString());

        // 避免超出Logcat最大长度限制
        for (String line : message.split("\n")) {
            final int length = line.length();

            int start = 0;
            do {
                int endIndex = start + Math.min(MAX_LINE_LENGTH, length - start);
                String part = line.substring(start, endIndex);
                start = endIndex;

                Log.println(infos.getPriority(), infos.getTag(), part);
            } while (length > 0 && start < length);
        }
    }

}
