/*
 * Decompiled with CFR 0.152.
 */
package co.com.sofka.application;

import co.com.sofka.application.ServiceBuildException;
import co.com.sofka.business.annotation.CommandHandles;
import co.com.sofka.business.annotation.CommandType;
import co.com.sofka.business.annotation.ExtensionService;
import co.com.sofka.business.asyn.UseCaseExecutor;
import co.com.sofka.business.generic.ServiceBuilder;
import co.com.sofka.business.generic.UseCaseHandler;
import co.com.sofka.business.repository.DomainEventRepository;
import co.com.sofka.domain.generic.DomainEvent;
import co.com.sofka.infraestructure.asyn.SubscriberEvent;
import co.com.sofka.infraestructure.handle.CommandExecutor;
import co.com.sofka.infraestructure.repository.EventStoreRepository;
import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationCommandExecutor
extends CommandExecutor {
    private static final Logger logger = Logger.getLogger(ApplicationCommandExecutor.class.getName());
    private final SubscriberEvent subscriberEvent;
    private final EventStoreRepository repository;
    private final String packageUseCase;

    public ApplicationCommandExecutor(String packageUseCase, SubscriberEvent subscriberEvent, EventStoreRepository repository) {
        this.subscriberEvent = subscriberEvent;
        this.repository = repository;
        this.packageUseCase = packageUseCase;
        this.initialize();
    }

    private void initialize() {
        logger.info("---- Registered Commands -----");
        try (ScanResult result = new ClassGraph().enableAllInfo().whitelistPackages(new String[]{this.packageUseCase}).scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(CommandHandles.class.getName());
            classInfos.parallelStream().forEach(handleClassInfo -> {
                AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(CommandType.class.getName());
                String type = this.getCommandType((ClassInfo)handleClassInfo, annotationInfo);
                String aggregate = this.getAggregate(annotationInfo);
                this.addHandle((ClassInfo)handleClassInfo, aggregate, type);
            });
        }
    }

    private String getCommandType(ClassInfo handleClassInfo, AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("name");
        }).orElse(handleClassInfo.loadClass().getCanonicalName().toLowerCase().replace(this.packageUseCase + ".", ""));
    }

    private String getAggregate(AnnotationInfo annotationInfo) {
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            return (String)paramVals.getValue("aggregate");
        }).orElse("default");
    }

    private ServiceBuilder getServiceBuilder(ClassInfo handleClassInfo) {
        AnnotationInfo annotationInfo = handleClassInfo.getAnnotationInfo(ExtensionService.class.getName());
        ServiceBuilder serviceBuilder = new ServiceBuilder();
        return Optional.ofNullable(annotationInfo).map(annotation -> {
            Object[] list;
            AnnotationParameterValueList paramVals = annotation.getParameterValues();
            for (Object o : list = (Object[])paramVals.getValue("value")) {
                try {
                    AnnotationClassRef ref = (AnnotationClassRef)o;
                    serviceBuilder.addService(ref.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.log(Level.SEVERE, "ERROR over service builder", e);
                    throw new ServiceBuildException(e);
                }
            }
            return serviceBuilder;
        }).orElse(serviceBuilder);
    }

    private void addHandle(ClassInfo handleClassInfo, final String aggregate, String type) {
        try {
            UseCaseExecutor handle = (UseCaseExecutor)handleClassInfo.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.put(type, (Consumer)handle.withSubscriberEvent((Flow.Subscriber)this.subscriberEvent).withUseCaseHandler(UseCaseHandler.getInstance()).withServiceBuilder(this.getServiceBuilder(handleClassInfo)).withDomainEventRepo(new DomainEventRepository(){

                public List<DomainEvent> getEventsBy(String aggregateRootId) {
                    return ApplicationCommandExecutor.this.repository.getEventsBy(aggregate, aggregateRootId);
                }

                public List<DomainEvent> getEventsBy(String aggregate2, String aggregateRootId) {
                    return ApplicationCommandExecutor.this.repository.getEventsBy(aggregate2, aggregateRootId);
                }
            }));
            String message = String.format("@@@@ %s Registered handle command with type --> %s", aggregate, type);
            logger.info(message);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, String.format("There is a error inside register command type -->%s", type), e);
        }
    }
}

