package cn.zoecloud.core.service;

import cn.zoecloud.core.internal.ZoeCloudConstants;
import cn.zoecloud.core.util.HttpUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * 请求消息
 * @author Leo
 */
public class RequestMessage {
    /**
     * 服务接入点，请求前缀
     */
    private String endpoint;

    /**
     * 资源路径，用于与endpoint实际拼接出请求地址
     */
    private String resourcePath;

    /**
     * 请求的HTTP Method
     */
    private HttpMethod method = HttpMethod.GET;

    /**
     * 请求参数
     */
    private Map<String, String> parameters = new LinkedHashMap<>();

    /**
     * 请求体
     */
    private String body;

    /**
     * Header
     */
    private Map<String, String> headers = new TreeMap<>(String.CASE_INSENSITIVE_ORDER);

    public RequestMessage(String endpoint, String resourcePath) {
        this.endpoint = endpoint;
        this.resourcePath = resourcePath;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getResourcePath() {
        return resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getUrl() {
        String paramString = HttpUtil.paramToQueryString(this.parameters, ZoeCloudConstants.DEFAULT_ENCODING);
        if (StringUtils.isBlank(paramString)) {
            return String.format("%s%s", this.endpoint, this.resourcePath);
        }
        return String.format("%s%s?%s", this.endpoint, this.resourcePath, paramString);
    }

    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}
