package cn.zoecloud.core.operation;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.model.GetTerminalPageRequest;
import cn.zoecloud.core.model.GetTerminalPageResult;
import cn.zoecloud.core.model.GetTerminalSingleRequest;
import cn.zoecloud.core.model.GetTerminalSingleResult;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ServiceClient;
import org.apache.commons.lang3.StringUtils;

import static cn.zoecloud.core.internal.ZoeCloudResponseParsers.getTerminalPageResponseParser;
import static cn.zoecloud.core.internal.ZoeCloudResponseParsers.getTerminalSingleResponseParser;

/**
 * 设备的操作
 * @author Leo
 */
public class ZoeCloudTerminalOperation extends ZoeCloudOperation {
    private static final String TERMINAL_PATH = "/api/2.0/terminals";
    private static final String GROUP_IDS_SEPARATOR = ",";

    public ZoeCloudTerminalOperation(ServiceClient client, Credential credential, String endpoint) {
        super(client, credential, endpoint);
    }

    public GetTerminalSingleResult getTerminal(GetTerminalSingleRequest getTerminalSingleRequest) throws ServiceException, ClientException {
        assert (getTerminalSingleRequest != null);
        RequestMessage request = new RequestMessage(this.getEndpoint(), String.format("%s/%s", TERMINAL_PATH, getTerminalSingleRequest.getId()));
        return doOperation(request, getTerminalSingleResponseParser);
    }

    public GetTerminalPageResult getTerminalPage(GetTerminalPageRequest getTerminalPageRequest) throws ServiceException, ClientException {
        assert (getTerminalPageRequest != null);
        StringBuilder url = new StringBuilder();
        url.append(String.format("%s?page=%d&size=%d", TERMINAL_PATH,
                getTerminalPageRequest.getPageRequest().getPageNumber(),
                getTerminalPageRequest.getPageRequest().getPageSize()));

        if (StringUtils.isNotBlank(getTerminalPageRequest.getPageRequest().getSortField())) {
            url.append(String.format("&sort=%s&order=%s",
                    getTerminalPageRequest.getPageRequest().getSortField(),
                    getTerminalPageRequest.getPageRequest().getOrder().toString()));
        }

        if (getTerminalPageRequest.getFilter() != null) {
            if (getTerminalPageRequest.getFilter().getOnline() != null) {
                url.append(String.format("&online=%b", getTerminalPageRequest.getFilter().getOnline()));
            }
            if (getTerminalPageRequest.getFilter().getGroupIds() != null && getTerminalPageRequest.getFilter().getGroupIds().size() > 0) {
                url.append(String.format("&groupIds=%s", StringUtils.join(getTerminalPageRequest.getFilter().getGroupIds(), GROUP_IDS_SEPARATOR)));
            }
            if (StringUtils.isNotBlank(getTerminalPageRequest.getFilter().getKeyword())) {
                url.append(String.format("&keyword=%s", getTerminalPageRequest.getFilter().getKeyword()));
            }
        }

        RequestMessage request = new RequestMessage(this.getEndpoint(), url.toString());
        return doOperation(request, getTerminalPageResponseParser);
    }
}
